% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uci_stop.R
\name{uci_stop}
\alias{uci_stop}
\title{Sending command stop for chess engine}
\usage{
uci_stop(engine)
}
\arguments{
\item{engine}{engine object}
}
\value{
engine object
}
\description{
Sending command stop for chess engine. Info about stop command from http://wbec-ridderkerk.nl/html/UCIProtocol.html
stop calculating as soon as possible, don't forget the "bestmove" and possibly the "ponder" token when finishing the search
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
e <- uci_engine(engine_path)
e <- uci_go(depth = 100)
Sys.sleep(1)
e <- uci_stop(e)
uci_quit(e)}
}
