% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigKRLS.R
\name{crossvalidate.bigKRLS}
\alias{crossvalidate.bigKRLS}
\title{crossvalidate.bigKRLS}
\usage{
crossvalidate.bigKRLS(y, X, seed, Kfolds = NULL, ptesting = NULL,
  estimates_subfolder = NULL, ...)
}
\arguments{
\item{y}{A vector of numeric observations on the dependent variable; missing values not allowed. May be base R matrix or library(bigmemory) big.matrix.}

\item{X}{A matrix of numeric observations of the independent variables; factors, missing values, and constant vectors not allowed. May be base R matrix or library(bigmemory) big.matrix.}

\item{seed}{Seed to be used when partitioning data. For example, crossvalidate.bigKRLS(..., seed = 123). ?set.seed for details.}

\item{Kfolds}{Number of folds for cross validation. Requires ptesting == NULL. Note KRLS assumes variation in each column; rare events or rarely observed factor levels may violate this assumption if Kfolds is too large given the data.}

\item{ptesting}{Percentage of data to be used for testing (e.g., ptesting = 20 means 80\% training, 20\% testing). Requires Kfolds == NULL. Note KRLS assumes variation in each column; rare events or rarely observed factor levels may violate this assumptions if ptesting is too small given the data.}

\item{estimates_subfolder}{If non-null, saves all model estimates in current working directory.}

\item{...}{Additional arguments to be passed to bigKRLS() or predict(). E.g., crossvalidate.bigKRLS(y, X, derivative = FALSE) will run faster but compute fewer test stats comparing in and out of sample performance (because the marginal effects will not be estimated).}
}
\value{
bigKRLS_CV (list) Object of estimates and summary stats; summary() is defined. For train/test, contains a bigKRLS regression object and a predict object. For Kfolds, contains a nested series of training and testing models.
}
\description{
crossvalidate.bigKRLS
}
\examples{
# y <- as.matrix(ChickWeight$weight)
# X <- matrix(cbind(ChickWeight$Time, ChickWeight$Diet == 1), ncol = 2)
# cv.out <- crossvalidate.bigKRLS(y, X, seed = 123, ptesting = 20)
# cv.out$pseudoR2_oos # cor(y[test], cv.out$tested$predicted)^2 == 0.7488783
# cv <- summary(cv.out)
# cv$training.ttests                      # hypothesis tests, training model
# kcv.out <- crossvalidate.bigKRLS(y, X, seed = 123, Kfolds = 3)
# kcv <- summary(kcv.out, digits = 3) 
# kcv$overview                   # test stats, in + out of sample, all folds
# kcv$training2.ttests                            # hypothesis tests, fold 2 
# save.bigKRLS(kcv.out, "myKfolds")
# load.bigKRLS("/path/to/myKfolds")     
}
