% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliospec.R
\docType{class}
\name{Bibliospec-class}
\alias{Bibliospec}
\alias{Bibliospec-class}
\alias{bibliospec}
\alias{blib}
\title{R access to Bibliospec File}
\description{
This class implements an R referenz class for BiblioSpec 
generated sqlite files and can return the data contained as data.frames
or as list of tandem mass spectra peptide assignments objects (psm).
}
\details{
The function performs a SQL query on the SQLite
files generated by BiblioSpec using the RSQLite package. 

BiblioSpec files are generated by using Skyline or the BiblioSpec command
line tool available from protwiz.
}
\section{Fields}{

\describe{
\item{\code{dbfile}}{database file location}
}}
\section{Methods}{

\describe{
\item{\code{getNrPSM()}}{Get number of psm's in database.}

\item{\code{getPeaks(asList = FALSE)}}{Get peaks - mz and intensity and spectra id as data.frame.}

\item{\code{getPsmSet()}}{get class psmSet S3 (list of psm objects).
psm objects can be viewed by using the peakplot
method of package protViz.}

\item{\code{getSpectraMeta()}}{Get spectra meta information - retention time , file name, num peaks as data.frame}

\item{\code{getSpectraWithMeta()}}{Get peaks with all the meta information as data.frame}

\item{\code{summary()}}{summary of bibliospec file}
}}
\examples{

library(bibliospec)

# use the sqlite file provided in the package
dbfile <- file.path(path.package("bibliospec"),
 "extdata/peptideStd.sqlite")

# call constructor
BS <- Bibliospec(dbfile=dbfile)

# test; should return TRUE
BS$getNrPSM() == 137

S <- BS$getPsmSet()

\dontrun{
 library(specL)
 print(S)
 lapply(S[1:10], plot)
}

peaks <- BS$getPeaks()

print(BS$summary())
head(peaks)

colnames(peaks)

spectrMet <- BS$getSpectraMeta()

dim(spectrMet)
alldata <- BS$getSpectraWithMeta()
alldata<- merge(spectrMet, peaks)

modification <- BS$getModification()

head(modification)

table(table(modification$RefSpectraID))

}
\author{
Witold E. Wolski and Christian Panse
}
\references{
\itemize{

\item{UNIT 13.7 Using BiblioSpec for Creating and Searching Tandem MS,
Peptide Libraries. Barbara Frewen, Michael J. MacCoss.
Current Protocols in Bioinformatics Current Protocols in Bioinformatics.
\url{http://dx.doi.org/10.1002/0471250953.bi1307s20}.}

\item{
The predecessor of the method \code{getPsmSet} was implemented in 
the bioconductor package \href{http://bioconductor.org/packages/specL/}{specL}:

Panse C, Trachsel C, Grossmann J and Schlapbach R. (2015). 
specL - An R/Bioconductor package to prepare peptide spectrum matches 
for use in targeted proteomics. 
Bioinformatics. 
\url{http://dx.doi.org/10.1093/bioinformatics/btv105}.}}
}
\seealso{
\itemize{
\item{\url{https://skyline.gs.washington.edu/labkey/project/home/software/Skyline/begin.view}}
\item{\url{https://skyline.gs.washington.edu/labkey/project/home/software/BiblioSpec/begin.view}}
}
}

