% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensions2df.R
\name{dimensions2df}
\alias{dimensions2df}
\title{Convert a Dimensions export file into a data frame}
\usage{
dimensions2df(file, format = "csv")
}
\arguments{
\item{file}{is a character vector containing Dimensions CSV/Excel file names.}

\item{format}{is a character indicating the format of the Dimensions export files. \code{format} can be \code{"csv"} or \code{"excel"}. Default is \code{format = "csv"}.}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It is an internal function used by \code{\link{convert2df}} to convert a Dimensions CSV(bibliomentric mapping)/Excel file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{

## Dimensions CSV (for bibliomentric mapping) file format example
# file <- c("filename1.csv", "filename2.csv")
# M <- dimensions2df(file, format = "csv")

## Dimensions Excel file format example
# file <- c("filename1.xlsx, "filename2.xlsx")
# M <- dimensions2df(file, format = "xlsx")

}
\seealso{
\code{\link{scopus2df}} for converting SCOPUS Export file (in bibtex format)

\code{\link{isibib2df}} for converting ISI Export file (in bibtex format)

\code{\link{isi2df}} for converting ISI Export file (in plain text format)

\code{\link{pubmed2df}} for converting an object of the class pubmed (RISmed package)

Other converting functions: \code{\link{bib2df}},
  \code{\link{cochrane2df}}, \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{isibib2df}},
  \code{\link{pubmed2df}}, \code{\link{scopus2df}}
}
\concept{converting functions}
