% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgw_mle_setup.R
\name{bgw_mle_setup}
\alias{bgw_mle_setup}
\title{bgw_mle_setup}
\usage{
bgw_mle_setup(p, n, hasAnalyticModelDeriv, control = NULL)
}
\arguments{
\item{p}{Number of parameters (components of x) being estimated. (Determined in bgw_mle from size of 'start' vector.}

\item{n}{Number of model residuals (in vector r). (Determined in bgw_mle by the size of the output vector from CalcR.)}

\item{hasAnalyticModelDeriv}{Logical. TRUE if CalcRJ has been provided. FALSE means that bgw_mle must employ finite-difference gradients (which has implications for storage allocation).}

\item{control}{List of bgw_mle control parameters (optional). If not provided, BGW default parameters will be used. If provided, default parameters will be overwritten by those corresponding parameters provided by the caller (but these must also be checked).}
}
\value{
iv and v vectors used by BGW Fortran.
}
\description{
Sets up R-level storage for bgw_mle.

This function replaces multiple Fortran subroutines from the BGW
Fortran code due at least in part to the prohibition against using
Fortran write statements in R packages. The current design produces
two vectors (iv_r and v_r) that mirror the main vectors required by the
Fortran code. For the moment, the idea is to create named vectors to
facilitate coding in bgw_mle. It may be that these could be deleted
(or overwritten by an as.numeric() conversion) prior to the main Fortran
calls.
}
