% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{RunMCMC}
\alias{RunMCMC}
\title{Run MCMC}
\usage{
RunMCMC(jags.model, params, name.list, data.list, initial.list, saved.steps,
  thinned.steps, run.contrasts, use.contrast, contrasts, n.data,
  credible.region, save.data = FALSE, ROPE, merge.MCMC, run.diag, sep,
  graphic.type = "pptx", plot.size = "15,10", scaling = 100,
  plot.aspect = NULL, vector.graphic = TRUE, point.size = 15,
  font.type = "serif", one.file = TRUE, ppi = 300, units = "in",
  paper = "pw", ...)
}
\arguments{
\item{jags.model}{specify which module to use}

\item{params}{define parameters to observe, Default: NULL}

\item{name.list}{list of names}

\item{data.list}{list of data}

\item{initial.list}{initial values for analysis, Default: list()}

\item{saved.steps}{define the number of iterations/steps/chains in the MCMC simulations, Default: 10000}

\item{thinned.steps}{save every kth step of the original saved.steps, Default: 1}

\item{run.contrasts}{logical, indicating whether or not to run contrasts, Default: FALSE}

\item{use.contrast}{choose from "between", "within" and "mixed". Between compare groups at different conditions. Within compare a group at different conditions. Mixed compute all comparisons.}

\item{contrasts}{define contrasts to use for analysis (defaults to all) , Default: NULL}

\item{n.data}{sample size for each parameter}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}

\item{save.data}{logical, indicating whether or not to save data, Default: FALSE}

\item{ROPE}{define range for region of practical equivalence (e.g., c(-0.05 , 0.05), Default: NULL}

\item{merge.MCMC}{logical, indicating whether or not to merge MCMC chains, Default: FALSE}

\item{run.diag}{logical, indicating whether or not to run diagnostics, Default: FALSE}

\item{sep}{symbol to separate data (e.g., comma-delimited), Default: ','}

\item{graphic.type}{type of graphics to use (e.g., pdf, png, ps), Default: 'pptx'}

\item{plot.size}{size of plot, Default: '15,10'}

\item{scaling}{scale size of plot, Default: 100}

\item{plot.aspect}{aspect of plot, Default: NULL}

\item{vector.graphic}{logical, indicating whether or not visualizations should be vector or raster graphics, Default: TRUE}

\item{point.size}{point size used for visualizations, Default: 15}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{one.file}{logical, indicating whether or not visualizations should be placed in one or several files, Default: TRUE}

\item{ppi}{define pixel per inch used for visualizations, Default: 300}

\item{units}{define unit of length used for visualizations, Default: 'in'}

\item{paper}{define a print size for visualizations, Default: 'pw'}

\item{...}{further arguments passed to or from other methods}
}
\value{
list containing MCMC chains , MCMC chains as matrix , summary of MCMC, list of name used, list of data, the jags model, running time of analysis and names of saved files
}
\description{
Conduct MCMC simulations using JAGS
}
\seealso{
\code{\link[runjags]{runjags.options}},\code{\link[runjags]{run.jags}}
 \code{\link[parallel]{detectCores}}
 \code{\link[coda]{as.mcmc.list}},\code{\link[coda]{varnames}}
 \code{\link[robust]{covRob}}
 \code{\link[stats]{cor}},\code{\link[stats]{cov}},\code{\link[stats]{sd}}
 \code{\link[pbapply]{pblapply}}
 \code{\link[MASS]{mvrnorm}}
 \code{\link[utils]{write.table}}
}
