% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intern__gibbs_pacf.R
\name{ar_screeType}
\alias{ar_screeType}
\title{Negative log likelihood values for scree-type plots}
\usage{
ar_screeType(data, order.max, method = "yw")
}
\arguments{
\item{data}{numeric vector of data}

\item{order.max}{maximum autoregressive order to consider}

\item{method}{character string giving the method used to fit the model, to be forwarded to \code{stats::\link{ar}}}
}
\value{
a data frame containing the autoregressive orders \code{p} and the corresponding negative log likelihood values \code{nll}
}
\description{
(Approximate) negative maximum log-likelihood for for different autoregressive orders to produce scree-type plots.
}
\details{
By default, the maximum likelihood is approximated by the Yule-Walker method, due to numerical stabililty and computational speed. Further details can be found in the simulation study section in the referenced paper.
}
\examples{
\dontrun{

###
### Interactive visual inspection for the sunspot data
###

data <- sqrt(as.numeric(sunspot.year))
data <- data <- data - mean(data)

screeType <- ar_screeType(data, order.max=15)

# Determine the autoregressive order by an interactive visual inspection of the scree-type plot
plot(x=screeType$p, y=screeType$nll, type="b")
p_ind <- identify(x=screeType$p, y=screeType$nll, n=1, labels=screeType$p)
print(screeType$p[p_ind])
}
}
\references{
C. Kirch et al. (2017)
\emph{Beyond Whittle: Nonparametric Correction of a Parametric Likelihood With a Focus on Bayesian Time Series Analysis}
<arXiv:1701.04846>
}

