% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{rBetaBinom}
\alias{rBetaBinom}
\title{Random Number Generation under the Beta-Binomial Probability Mass Distribution.}
\usage{
rBetaBinom(n, N, l, u, alpha, beta)
}
\arguments{
\item{n}{Number of draws.}

\item{N}{Number of trials.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The alpha (first) shape parameter.}

\item{beta}{The beta (second) shape parameter.}
}
\value{
A vector with length \code{n} of random values drawn from the Beta-Binomial Distribution.
}
\description{
Random Number Generation under the Beta-Binomial Probability Mass Distribution.
}
\examples{
# To draw a sample of 50 values from a Beta-Binomial distribution with
# number of trials = 100, and with success-probabilities drawn from a
# Four-Parameter Beta distribution with location parameters l = 0.25 and
# u = 0.95, and shape-parameters alpha = 5 and beta = 3:
rBetaBinom(n = 50, N = 100, l = 0.25, u = 0.95, alpha = 5, beta = 3)
}
