% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.betaclust.R
\name{summary.betaclust}
\alias{summary.betaclust}
\title{Summarizing the beta mixture model fits}
\usage{
\method{summary}{betaclust}(object, ...)
}
\arguments{
\item{object}{A \code{\link[betaclust:betaclust]{betaclust}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[betaclust:summary.betaclust]{summary.betaclust}} which contains the following list:
\itemize{
\item C - The number of CpG sites analysed using the beta mixture models.
\item N - The number of patients analysed using the beta mixture models.
\item R - The number of samples analysed using the beta mixture models.
\item K - The number of methylation states in R DNA samples.
\item modelName - The optimal model selected.
\item loglik - The log-likelihood value for the selected optimal model.
\item information_criterion - The information criterion used to select the optimal model.
\item ic_output - This stores the information criterion value calculated for each model.
\item classification - The total number of CpG sites in each cluster.
\item prop_data - The proportion of CpG sites in each cluster.}
}
\description{
Summary method for a \code{\link[betaclust:betaclust]{betaclust}} object containing the results under the optimal model selected.
}
\examples{
\donttest{
my.seed <- 190
M <- 3
N <- 4
R <- 2
data_output <- betaclust(pca.methylation.data[1:30,2:9], M, N, R,
            model_names=c("K..","KN.","K.R"), model_selection="BIC",
            parallel_process = FALSE, seed=my.seed)
summary(data_output)}
}
\seealso{
\code{\link{betaclust}}
}
