% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods-mc.R
\name{summary.mc}
\alias{summary.mc}
\title{Summary Method for an Object of Class
\code{mc}}
\usage{
\method{summary}{mc}(object, digits = 4, ...)
}
\arguments{
\item{object}{Object of Class \code{mc},
that is,
the output of the
\code{MC()}
function.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a list with the following elements:
\describe{
\item{mean}{Mean of the sampling distribution of
\eqn{\boldsymbol{\hat{\theta}}}.}
\item{var}{Variance of the sampling distribution of
\eqn{\boldsymbol{\hat{\theta}}}.}
\item{bias}{Monte Carlo simulation bias.}
\item{rmse}{Monte Carlo simulation root mean square error.}
\item{location}{Location parameter used in the Monte Carlo simulation.}
\item{scale}{Scale parameter used in the Monte Carlo simulation.}
}
}
\description{
Summary Method for an Object of Class
\code{mc}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
mc <- MC(object, R = 100)
summary(mc)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
