% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_x.R
\name{exp_x}
\alias{exp_x}
\alias{predict.exp_x}
\alias{print.exp_x}
\title{exp(x) Transformation}
\usage{
exp_x(x, standardize = TRUE, warn = TRUE, ...)

\method{predict}{exp_x}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{exp_x}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with with x}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal}

\item{warn}{Should a warning result from infinite values?}

\item{...}{additional arguments}

\item{object}{an object of class 'exp_x'}

\item{newdata}{a vector of data to be (potentially reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{exp_x} with elements 
\item{x.t}{transformed 
  original data} 
  \item{x}{original data} 
  \item{mean}{mean after transformation but prior to standardization} 
  \item{sd}{sd after transformation but prior to standardization} 
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom}
  \item{standardize}{was the transformation standardized}
  
  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform a exp(x) transformation
}
\details{
\code{exp_x} performs a simple exponential transformation in the context of 
bestNormalize, such that it creates a transformation that can be estimated
and applied to new data via the \code{predict} function.
}
\examples{
x <- rgamma(100, 1, 1)

exp_x_obj <- exp_x(x)
exp_x_obj
p <- predict(exp_x_obj)
x2 <- predict(exp_x_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
