% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableColVal.R
\name{tableColVal}
\alias{tableColVal}
\title{Table with values with value-dependent colored backgrounds in pdf}
\usage{
tableColVal(
  mat,
  main = deparse(substitute(mat)),
  nameswidth = 0.3,
  namesheight = 0.1,
  palette = seqPal(100),
  Range = range(mat, finite = TRUE),
  digits = 0,
  na.rm = TRUE,
  ...,
  roundargs = NULL,
  classargs = NULL,
  cellargs = NULL,
  colargs = NULL,
  rowargs = NULL,
  mainargs = NULL
)
}
\arguments{
\item{mat}{Matrix with values and row/column names}

\item{main}{Title for topleft space. DEFAULT: name of mat object.}

\item{nameswidth}{Relative width of row names at the left, as a percentage of plot.
DEFAULT: 0.3}

\item{namesheight}{Relative height of column names at the top. DEFAULT: 0.1}

\item{palette}{Color palette for the heatmap. DEFAULT: \code{\link{seqPal}(100)}}

\item{Range}{Range mapped to color palette. DEFAULT: range(mat)}

\item{digits}{Number of digits rounded to for writing. DEFAULT: 0}

\item{na.rm}{Remove NA from labels? New in May 2022. DEFAULT: TRUE}

\item{\dots}{Further arguments passed to all \code{\link{text}} like cex, col, srt, ...}

\item{roundargs}{List with arguments to \code{\link{round0}}. 
\code{pre} and \code{big.mark} have internal defaults.}

\item{classargs}{List of arguments specifying how to call \code{\link{classify}},
e.g. method. DEFAULT: NULL}

\item{cellargs, colargs, rowargs, mainargs}{List of arguments passed to \code{\link{text}}
only for the cells, column labels, row labels or title,
respectively. DEFAULTS: NULL}
}
\value{
List of locations in plot.
}
\description{
Table with numbers and corresponding color in the background of each cell.
(heatmap)
}
\details{
Create tables with corresponding color in the background of each cell. (heatmap)
}
\examples{

Bsp <- matrix(c(21,23,26,27, 18,24,25,28, 14,17,23,23, 16,19,21,25), ncol=4, byrow=TRUE)
colnames(Bsp) <- paste0("Measure", LETTERS[1:4])
rownames(Bsp) <- paste("prod", 8:11, sep="_")
Bsp

(  tableColVal(Bsp)   )
tableColVal(Bsp, nameswidth=0.1) # relative to plot width
tableColVal(Bsp, namesheight=0.5, srt=45)
tableColVal(Bsp, namesheight=0.5, colargs=c(srt=45))

tableColVal(Bsp, cellargs=list(cex=2), col="red")
tableColVal(Bsp, Range=c(10,40))
tableColVal(Bsp, Range=c(20,40))
tableColVal(Bsp, palette=heat.colors(12))
tableColVal(Bsp, palette=c(2,4,7), main="more\nstuff")

Bsp2 <- matrix(rexp(30), ncol=6, byrow=TRUE)
(  tableColVal(Bsp2)  )
tableColVal(Bsp2, digits=4)
colPointsLegend(Bsp2, horizontal=FALSE, x1=0.05, x2=0.15, y1=0.1, y2=0.8, title="")

\dontrun{
## Rcmd check --as-cran doesn't like to open external devices such as pdf,
## so this example is excluded from running in the checks.
pdf("TableColVal.pdf", height=5);  tableColVal(Bsp);  dev.off()
openFile("TableColVal.pdf")
unlink("TableColVal.pdf")
}

}
\seealso{
\code{\link{pdf}}, \code{\link{heatmap}}, \code{\link{sortDF}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Nov 2012 + Nov 2016
}
\keyword{hplot}
