% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googleLink2pdf.R
\name{googleLink2pdf}
\alias{googleLink2pdf}
\title{extract pdf link from google search result}
\usage{
googleLink2pdf(googlelink)
}
\arguments{
\item{googlelink}{Character string: A search result address}
}
\value{
Characterstring with only the basic link
}
\description{
restrict pdf link from a google search to actual link with text processing
}
\note{
The function is not vectorized! If you have many links, use a loop around this function...
}
\examples{

Link <- paste0("https://www.google.de/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1",
        "&cad=rja&sqi=2&ved=0CDIQFjAA&url=http\%3A\%2F\%2Fcran.r-project.org",
        "\%2Fdoc\%2Fmanuals\%2FR-intro.pdf&ei=Nyl4UfHeOIXCswa6pIC4CA",
        "&usg=AFQjCNGejDwPlor4togQZmQEQv72cK9z8A&bvm=bv.45580626,d.Yms")
googleLink2pdf(Link)

Link <- paste0("https://www.google.de/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1",
        "&cad=rja&uact=8&ved=0ahUKEwjLlfmClavRAhWaN1AKHcGSBjEQFgghMAA",
        "&url=http\%3A\%2F\%2Fstackoverflow.com\%2Fquestions\%2Ftagged\%2Fr",
        "&usg=AFQjCNHYj6HjSs6Lvczn9wMWxE3slCdq1Q&bvm=bv.142059868,d.ZWM")
googleLink2pdf(Link)
Link <- paste0("https://www.google.de/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2",
        "&cad=rja&uact=8&ved=0ahUKEwjLlfmClavRAhWaN1AKHcGSBjEQFggpMAE&",
        "url=http\%3A\%2F\%2Fstackoverflow.com\%2Fquestions\%2Ftagged\%2F\%3Ftagnames",
        "\%3Dr\%26sort\%3Dactive&usg=AFQjCNGkPGHq05qwKLLW4vRXdmk2Olhmig&bvm=bv.142059868,d.ZWM")
googleLink2pdf(Link)

}
\seealso{
\code{\link{strsplit}}, \code{\link{gsub}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2012
}
\keyword{character}
