% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colPoints.R
\name{colPoints}
\alias{colPoints}
\title{Points colored relative to third dimension}
\usage{
colPoints(
  x,
  y,
  z,
  data,
  add = TRUE,
  col = seqPal(100),
  col2 = c(NA, "grey", "black"),
  Range = range(z, finite = TRUE),
  method = "linear",
  breaks = length(col),
  sdlab = 1,
  legend = TRUE,
  legargs = NULL,
  lines = FALSE,
  nint = 30,
  xlab = gsub("\\"", "", deparse(substitute(x))),
  ylab = gsub("\\"", "", deparse(substitute(y))),
  zlab = gsub("\\"", "", deparse(substitute(z))),
  axes = TRUE,
  log = "",
  las = 1,
  bglines = NULL,
  pch = 16,
  x1 = 0.6,
  y1 = ifelse(horizontal, 0.88, 0.3),
  x2 = 0.99,
  y2 = 0.99,
  density = NULL,
  horizontal = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x, y}{Vectors with coordinates of the points to be drawn}

\item{z}{z values belonging to coordinates.
Vector or matrix with the color-defining height values}

\item{data}{Optional: data.frame with the column names as given by x,y and z.}

\item{add}{Logical. Should the points be added to current (existing!) plot?
If FALSE, a new plot is started.
DEFAULT: TRUE (It's called col\bold{Points}, after all)}

\item{col}{Vector of colors to be used. DEFAULT: 100 colors from sequential
palette \code{\link{seqPal}} (color-blind safe, black/white-print safe)}

\item{col2}{Color for points where z is NA, or lower / higher than \code{Range}.
DEFAULT: c(NA, 1, 8)}

\item{Range}{Ends of color bar. If NULL, it is again the DEFAULT: range(z, finite=TRUE)}

\item{method}{Classification method (partial matching is performed),
see \code{\link{classify}}. DEFAULT: "linear"}

\item{breaks}{Specification for method, see \code{\link{classify}}.
DEFAULT: different defaults for each method}

\item{sdlab}{Type of label and breakpoints if \code{method="sd"},
see \code{\link{classify}}. DEFAULT: 1}

\item{legend}{Logical. Should a \code{\link{colPointsLegend}} be drawn? DEFAULT: TRUE}

\item{legargs}{List. Arguments passed to \code{\link{colPointsLegend}}.
DEFAULT: NULL, with some defaults specified internally}

\item{lines}{Logical. Should lines be drawn instead of / underneath the points?
(color of each \code{\link{segments}} is taken from starting point,
last point is endpoint.) If lines=TRUE and pch is not given,
pch is set to NA. DEFAULT: FALSE}

\item{nint}{Numeric of length 1. Number of interpolation points between each
coordinate if \code{lines=TRUE}. nint=1 means no interpolation.
Values below 10 will smooth coordinates and might
miss the original points. DEFAULT: 30}

\item{xlab, ylab, zlab}{X axis label, y axis label, \code{\link{colPointsLegend} title}.
DEFAULT: \code{gsub("\\"", "", deparse(\link{substitute}(x/y/z)))}}

\item{axes, las}{Draw axes? Label Axis Style. Only used when add=FALSE.
See \code{\link{par}}. DEFAULT: axes=TRUE, las=1 (all labels horizontal)}

\item{log}{Logarithmic axes with log="y", "xy" or "x". DEFAULT: ""}

\item{bglines}{If not NULL, passed to \code{\link{abline}} to draw background
lines before adding colored points. DEFAULT: NULL}

\item{pch}{Point CHaracter. See \code{\link{par}}. DEFAULT: 16}

\item{x1, x2, y1, y2}{Relative coordinates [0:1] of inset plot, see \code{\link{smallPlot}}.
Passed to \code{\link{colPointsLegend}}.
DEFAULT: x: 0.6-0.99, y: 0.88-0.98}

\item{density}{Arguments for density line in \code{\link{colPointsLegend}},
or FALSE to suppress drawing it. DEFAULT: NULL}

\item{horizontal}{Logical passed to \code{\link{colPointsLegend}}. DEFAULT: TRUE}

\item{quiet}{Turn off warnings? DEFAULT: FALSE}

\item{\dots}{Further graphical arguments passed to \code{\link{plot}},
\code{\link{points}} and \code{\link{segments}},
eg cex, xlim (when add=F), mgp, main, sub, asp (when add=F), etc.
Note: col does not work, as it is already another argument}
}
\value{
Invisible list of values that can be passed to colPointsLegend or colPointsHist.
}
\description{
Draw colored points for 3D-data in a 2D-plane. Color is relative to third
dimension, by different classification methods. Can take 3 vectors or, as in
\code{\link{image}}, 2 vectors and a matrix for z.\cr
Adding points after \code{\link{smallPlot}} is called for the legend may be
incorrect if the original function messes with the graph margins,
see the note in \code{\link{colPointsLegend}}.
}
\note{
Rstudio scales graphics really badly, so don't expect the right legend width out of the box if you use Rstudio!
     Exporting via \code{png("myplot.png", 600,400); colPoints(x,y,z); dev.off()} usually works much better
}
\examples{

i <- c( 22,  40,  48,  60,  80,  70,  70,  63,  55,  48,  45,  40,  30,  32)
j <- c(  5,  10,  15,  20,  12,  30,  45,  40,  30,  36,  56,  33,  45,  23)
k <- c(175, 168, 163, 132, 120, 117, 110, 130, 131, 160, 105, 174, 190, 183)

# basic usage:
colPoints(i,j,k, cex=1.5, pch="+", add=FALSE)

# with custom Range:
colPoints(i,j,k, cex=1.5, pch="+", add=FALSE, Range=c(150,190), density=FALSE)
# can be used to allow comparison between several plots
# points outside the range are plotted with col2

# with custom colors:
mycols <- colorRampPalette(c("blue","yellow","red"))(50)
colPoints(i,j,k, cex=1.5, pch="+", add=FALSE, col=mycols)

# With legend title:
colPoints(i,j,k, cex=2, add=FALSE, zlab="Elevation [m above NN.]",
         legargs=list(density=FALSE))
?colPointsLegend # to see which arguments can be set via legargs


# colPoints with matrix:
colPoints(z=volcano, add=FALSE)
# image and contour by default transpose and reverse the matrix!
# colPoints shows what is really in the data.

# add single newly measured points to image (fictional data):
mx <- c( 22,  40,  45,  30,  30,  10)
my <- c(  5,  33,  56,  70,  45,  45)
mz <- c(110, 184, 127, 133, 170, 114)
colPoints(mx,my,mz, cex=5, pch="*", Range=c(94, 195), col=seqPal(), col2=NA, legend=FALSE)
points(mx,my, cex=4)
text(mx,my,mz, adj=-0.5, font=2)


# with lines (nint to change number of linear interpolation points):
colPoints(i,j,k, cex=1.5, add=FALSE, lines=TRUE, nint=10, lwd=2)
# With NAs separating lines:
tfile <- system.file("extdata/rivers.txt", package="berryFunctions")
rivers <- read.table(tfile, header=TRUE, dec=",")
colPoints(x,y,n, data=rivers, add=FALSE, lines=TRUE)
colPoints(x,y,n, data=rivers, add=FALSE, lines=TRUE, pch=3, lwd=3)
colPoints(x,y,n, data=rivers, add=FALSE, lines=TRUE, pch=3, lwd=3, nint=2)
colPoints("x","y","n", data=rivers, add=FALSE)

# different classification methods:
# see ?classify

colPoints(i,j,k, add=FALSE) # use classify separately:
text(i,j+1,k, col=divPal(100,rev=TRUE)[classify(k)$index], cex=1)


# Add histogram:
cp <- colPoints(i,j,k, add=FALSE)
do.call(colPointsHist, cp[c("z","at","labels","bb","nbins")])
do.call(colPointsHist, owa(cp[c("z","at","labels","bb","nbins")],
                           list(bg=5, breaks=5)))
do.call(colPointsHist, owa(cp[c("z","at","labels","bb","nbins")],
                           list(mar=c(0,0,0,0), x1=0.5, x2=1, y1=0.8,
                             y2=0.99, yaxt="n")))
# histogram in lower panel:
layout(matrix(1:2), heights=c(8,4) )
colPoints(i,j,k, add=FALSE, y1=0.8, y2=1)
colPointsHist(z=k, x1=0.05, x2=1, y1=0, y2=0.4, mar=3, outer=TRUE)
layout(1)


# Customizing the legend :
cp <- colPoints(i,j,k, legend=FALSE, add=FALSE)
colPointsLegend(x1=0.2, x2=0.95, y1=0.50, y2=0.40, z=k, labelpos=5, atminmax=TRUE, bg=7)
colPointsLegend(x1=0.5, x2=0.90, y1=0.28, y2=0.18, z=k, Range=c(80, 200), nbins=12, font=3)
colPointsLegend(x1=0.1, x2=0.40, y1=0.15, y2=0.05, z=k, labelpos=5, lines=FALSE, title="")
colPointsLegend(z=k, horizontal=FALSE)
colPointsLegend(x1=0.01, y2=0.80, z=k, horizontal=FALSE, labelpos=4, cex=1.2)
colPointsLegend(x1=0.23, y2=0.95, z=k, horizontal=FALSE, labelpos=5, cex=0.8,
  dens=FALSE, title="", at=c(130,150,170), labels=c("y","rr","Be"), lines=FALSE)
# For method other than colPoints' default, it is easiest to include these
# options as a list in legargs, but you can also use the invisible output
# from colPoints for later calls to colPointsLegend
do.call(colPointsLegend, cp)
do.call(colPointsLegend, owa(cp, list(colors=divPal(100), cex=1.2)))


# santiago.begueria.es/2010/10/generating-spatially-correlated-random-fields-with-r
if(require(gstat)){
xyz <- gstat(formula=z~1, locations=~x+y, dummy=TRUE, beta=1,
             model=vgm(psill=0.025,model="Exp",range=5), nmax=20)
xyz <- predict(xyz, newdata=data.frame(x=runif(200, 20,40),y=runif(200, 50,70)), nsim=1)
head(xyz)
colPoints(x,y,sim1, data=xyz, add=FALSE)
}

}
\references{
\url{http://uxblog.idvsolutions.com/2011/10/telling-truth.html},
            \url{http://www.theusrus.de/blog/the-good-the-bad-22012/}
}
\seealso{
\code{\link{classify}}, \code{\link{colPointsLegend}}, \code{\link{colPointsHist}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2011-2014. I'd be interested in hearing what you used the function for.
}
\keyword{aplot}
\keyword{color}
\keyword{hplot}
