% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqPal.R
\name{seqPal}
\alias{seqPal}
\title{Sequential color palette}
\usage{
seqPal(n = 12, reverse = FALSE, alpha = 1, extr = FALSE, yb = FALSE,
  yr = FALSE, gb = FALSE, b = FALSE, colors = NULL, logbase = 1, ...)
}
\arguments{
\item{n}{Number of colors. DEFAULT: 12}

\item{reverse}{Reverse colors? DEFAULT: FALSE}

\item{alpha}{Transparency (0=transparent, 1=fully colored). DEFAULT: 1}

\item{extr}{Should colors span possible range more extremely?
If TRUE, it has very light yellow and very dark blue values included,
using the result from \code{RColorBrewer::brewer.pal(9, "YlGnBu")}. DEFAULT: FALSE}

\item{yb}{Should colors be in yellow-blue instead of the internal (nice) default? DEFAULT: FALSE}

\item{yr}{Should colors be in yellow-red instead of the default? DEFAULT: FALSE}

\item{gb}{Should colors be in green-blue instead of the default? DEFAULT: FALSE}

\item{b}{Should colors be in an increasingly saturated blue? DEFAULT: FALSE}

\item{colors}{If not NULL, a color vector used in \code{\link{colorRampPalette}}. DEFAULT: NULL}

\item{logbase}{If \code{!=1}, this is passed to \code{\link{classify}} and \code{\link{logSpaced}}. DEFAULT: 1}

\item{\dots}{Further arguments passed to \code{\link{colorRamp}}}
}
\value{
Character string vector with color names
}
\description{
Sequential color palette from yellow to red or yellow to blue or custom colors.
}
\examples{

plot(rep(1,12),  pch=16, cex=5, col=seqPal(12), xaxt="n")
showPal()

# nonlinear color scale (use colPoints + see classify for more options):
v <- rescale(volcano^30)
image(v, col=seqPal(1000), asp=1);  colPointsLegend(v, nbins=1000)
image(v, col=seqPal(1000, logbase=1.007), asp=1)
colPointsLegend(v, col=seqPal(1000, logbase=1.007))

plot(    rep(1, 1000), pch=15, cex=3, col=seqPal(1000), ylim=c(0.99, 1.01), ylab="logbase", las=1)
for(b in seq(0.99, 1.01, len=30))
    points(rep(b, 1000), pch=15, cex=1, col=seqPal(1000, logbase=b))

}
\seealso{
\code{\link{showPal}}, \code{\link{divPal}}, \code{\link{addAlpha}},
         \code{\link{colorRampPalette}}, package \code{RColorBrewer}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2016
}
\keyword{color}
\keyword{dplot}
