% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatable.R
\name{get_datatable}
\alias{get_datatable}
\title{Interactive table of results}
\usage{
get_datatable(results, test_group = unique(results$test_group),
  byte_optimize = get_byte_compiler(),
  blas_optimize = is_blas_optimize(results))
}
\arguments{
\item{results}{Benchmark results. Probably obtained from 
\code{benchmark_std()} or \code{benchmark_io()}.}

\item{test_group}{Default \code{unique(x$test_group)}. 
The default behaviour is select the groups from your benchmark results.}

\item{byte_optimize}{The default behaviour is to compare your results with results that use the same 
byte_optimized setting. To use all results, set to \code{NULL}.}

\item{blas_optimize}{Logical. Default The default behaviour 
is to compare your results with results that use the same 
blas_optimize setting. To use all results, set to \code{NULL}.}
}
\description{
Compare your results against past results. Your results is 
shown in Orange.
}
\examples{
## Using example data
data("sample_results", package="benchmarkme")
plot(sample_results)

## Your results
\dontrun{
res = benchmark_std(3)
plot(res)
}
}
