// Generated by rstantools.  Do not edit by hand.

/*
    bellreg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bellreg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bellreg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_zibellreg_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 167> locations_array__ =
  {" (found before start of program)",
  " (in 'zibellreg', line 166, column 2 to column 20)",
  " (in 'zibellreg', line 167, column 2 to column 21)",
  " (in 'zibellreg', line 170, column 2 to column 16)",
  " (in 'zibellreg', line 171, column 2 to column 17)",
  " (in 'zibellreg', line 196, column 2 to column 81)",
  " (in 'zibellreg', line 175, column 4 to column 43)",
  " (in 'zibellreg', line 176, column 4 to column 58)",
  " (in 'zibellreg', line 174, column 7 to line 177, column 3)",
  " (in 'zibellreg', line 173, column 4 to column 34)",
  " (in 'zibellreg', line 172, column 10 to line 174, column 3)",
  " (in 'zibellreg', line 172, column 2 to line 177, column 3)",
  " (in 'zibellreg', line 181, column 4 to column 41)",
  " (in 'zibellreg', line 182, column 4 to column 55)",
  " (in 'zibellreg', line 180, column 7 to line 183, column 3)",
  " (in 'zibellreg', line 179, column 4 to column 32)",
  " (in 'zibellreg', line 178, column 10 to line 180, column 3)",
  " (in 'zibellreg', line 178, column 2 to line 183, column 3)",
  " (in 'zibellreg', line 187, column 11 to column 12)",
  " (in 'zibellreg', line 187, column 4 to column 82)",
  " (in 'zibellreg', line 188, column 4 to column 26)",
  " (in 'zibellreg', line 191, column 6 to column 45)",
  " (in 'zibellreg', line 192, column 6 to column 42)",
  " (in 'zibellreg', line 189, column 19 to line 193, column 5)",
  " (in 'zibellreg', line 189, column 4 to line 193, column 5)",
  " (in 'zibellreg', line 147, column 2 to column 17)",
  " (in 'zibellreg', line 148, column 2 to column 17)",
  " (in 'zibellreg', line 149, column 2 to column 17)",
  " (in 'zibellreg', line 150, column 8 to column 9)",
  " (in 'zibellreg', line 150, column 2 to column 26)",
  " (in 'zibellreg', line 151, column 9 to column 10)",
  " (in 'zibellreg', line 151, column 12 to column 13)",
  " (in 'zibellreg', line 151, column 2 to column 17)",
  " (in 'zibellreg', line 152, column 9 to column 10)",
  " (in 'zibellreg', line 152, column 12 to column 13)",
  " (in 'zibellreg', line 152, column 2 to column 17)",
  " (in 'zibellreg', line 153, column 2 to column 12)",
  " (in 'zibellreg', line 154, column 2 to column 12)",
  " (in 'zibellreg', line 155, column 13 to column 14)",
  " (in 'zibellreg', line 155, column 2 to column 23)",
  " (in 'zibellreg', line 156, column 18 to column 19)",
  " (in 'zibellreg', line 156, column 2 to column 26)",
  " (in 'zibellreg', line 157, column 13 to column 14)",
  " (in 'zibellreg', line 157, column 2 to column 23)",
  " (in 'zibellreg', line 158, column 18 to column 19)",
  " (in 'zibellreg', line 158, column 2 to column 26)",
  " (in 'zibellreg', line 159, column 2 to column 33)",
  " (in 'zibellreg', line 160, column 2 to column 15)",
  " (in 'zibellreg', line 161, column 2 to column 27)",
  " (in 'zibellreg', line 162, column 2 to column 14)",
  " (in 'zibellreg', line 163, column 2 to column 26)",
  " (in 'zibellreg', line 166, column 9 to column 10)",
  " (in 'zibellreg', line 167, column 9 to column 10)",
  " (in 'zibellreg', line 170, column 9 to column 10)",
  " (in 'zibellreg', line 171, column 9 to column 10)",
  " (in 'zibellreg', line 196, column 9 to column 10)",
  " (in 'zibellreg', line 5, column 2 to column 27)",
  " (in 'zibellreg', line 6, column 9 to column 10)",
  " (in 'zibellreg', line 6, column 2 to column 14)",
  " (in 'zibellreg', line 8, column 5 to column 30)",
  " (in 'zibellreg', line 7, column 15 to line 9, column 3)",
  " (in 'zibellreg', line 7, column 2 to line 9, column 3)",
  " (in 'zibellreg', line 10, column 2 to column 12)",
  " (in 'zibellreg', line 4, column 28 to line 11, column 1)",
  " (in 'zibellreg', line 24, column 7 to column 30)",
  " (in 'zibellreg', line 23, column 22 to column 41)",
  " (in 'zibellreg', line 23, column 7 to line 24, column 30)",
  " (in 'zibellreg', line 22, column 22 to column 32)",
  " (in 'zibellreg', line 22, column 7 to line 24, column 30)",
  " (in 'zibellreg', line 21, column 22 to column 37)",
  " (in 'zibellreg', line 21, column 2 to line 24, column 30)",
  " (in 'zibellreg', line 25, column 2 to column 12)",
  " (in 'zibellreg', line 20, column 41 to line 26, column 1)",
  " (in 'zibellreg', line 42, column 7 to column 30)",
  " (in 'zibellreg', line 41, column 22 to column 52)",
  " (in 'zibellreg', line 41, column 7 to line 42, column 30)",
  " (in 'zibellreg', line 40, column 22 to column 46)",
  " (in 'zibellreg', line 40, column 7 to line 42, column 30)",
  " (in 'zibellreg', line 39, column 22 to column 38)",
  " (in 'zibellreg', line 39, column 7 to line 42, column 30)",
  " (in 'zibellreg', line 38, column 22 to column 45)",
  " (in 'zibellreg', line 38, column 2 to line 42, column 30)",
  " (in 'zibellreg', line 43, column 2 to column 12)",
  " (in 'zibellreg', line 36, column 41 to line 44, column 1)",
  " (in 'zibellreg', line 51, column 4 to column 11)",
  " (in 'zibellreg', line 52, column 4 to column 11)",
  " (in 'zibellreg', line 53, column 4 to column 28)",
  " (in 'zibellreg', line 54, column 4 to column 73)",
  " (in 'zibellreg', line 55, column 4 to column 37)",
  " (in 'zibellreg', line 56, column 4 to column 37)",
  " (in 'zibellreg', line 57, column 4 to column 37)",
  " (in 'zibellreg', line 58, column 4 to column 14)",
  " (in 'zibellreg', line 50, column 23 to line 59, column 3)",
  " (in 'zibellreg', line 65, column 4 to column 10)",
  " (in 'zibellreg', line 66, column 11 to column 12)",
  " (in 'zibellreg', line 66, column 4 to column 16)",
  " (in 'zibellreg', line 67, column 11 to column 12)",
  " (in 'zibellreg', line 67, column 4 to column 19)",
  " (in 'zibellreg', line 68, column 4 to column 13)",
  " (in 'zibellreg', line 70, column 6 to column 12)",
  " (in 'zibellreg', line 71, column 6 to column 21)",
  " (in 'zibellreg', line 73, column 8 to column 41)",
  " (in 'zibellreg', line 72, column 26 to line 74, column 7)",
  " (in 'zibellreg', line 72, column 6 to line 74, column 7)",
  " (in 'zibellreg', line 76, column 8 to column 23)",
  " (in 'zibellreg', line 75, column 19 to line 77, column 7)",
  " (in 'zibellreg', line 75, column 6 to line 77, column 7)",
  " (in 'zibellreg', line 69, column 24 to line 78, column 5)",
  " (in 'zibellreg', line 69, column 4 to line 78, column 5)",
  " (in 'zibellreg', line 79, column 4 to column 24)",
  " (in 'zibellreg', line 64, column 7 to line 80, column 3)",
  " (in 'zibellreg', line 63, column 4 to column 14)",
  " (in 'zibellreg', line 62, column 11 to line 64, column 3)",
  " (in 'zibellreg', line 62, column 2 to line 80, column 3)",
  " (in 'zibellreg', line 61, column 23 to line 81, column 1)",
  " (in 'zibellreg', line 85, column 4 to column 12)",
  " (in 'zibellreg', line 86, column 4 to column 15)",
  " (in 'zibellreg', line 87, column 4 to column 23)",
  " (in 'zibellreg', line 88, column 4 to column 66)",
  " (in 'zibellreg', line 89, column 4 to column 17)",
  " (in 'zibellreg', line 84, column 33 to line 90, column 3)",
  " (in 'zibellreg', line 104, column 10 to column 25)",
  " (in 'zibellreg', line 104, column 4 to column 38)",
  " (in 'zibellreg', line 106, column 6 to column 52)",
  " (in 'zibellreg', line 105, column 31 to line 107, column 5)",
  " (in 'zibellreg', line 105, column 4 to line 107, column 5)",
  " (in 'zibellreg', line 108, column 4 to column 22)",
  " (in 'zibellreg', line 103, column 51 to line 109, column 3)",
  " (in 'zibellreg', line 112, column 2 to column 26)",
  " (in 'zibellreg', line 113, column 9 to column 10)",
  " (in 'zibellreg', line 113, column 2 to column 18)",
  " (in 'zibellreg', line 114, column 9 to column 10)",
  " (in 'zibellreg', line 114, column 2 to column 24)",
  " (in 'zibellreg', line 115, column 9 to column 10)",
  " (in 'zibellreg', line 115, column 2 to column 40)",
  " (in 'zibellreg', line 116, column 8 to column 9)",
  " (in 'zibellreg', line 116, column 2 to column 22)",
  " (in 'zibellreg', line 118, column 4 to column 33)",
  " (in 'zibellreg', line 119, column 4 to column 42)",
  " (in 'zibellreg', line 117, column 15 to line 120, column 3)",
  " (in 'zibellreg', line 117, column 2 to line 120, column 3)",
  " (in 'zibellreg', line 121, column 2 to column 15)",
  " (in 'zibellreg', line 111, column 69 to line 122, column 1)",
  " (in 'zibellreg', line 126, column 4 to column 28)",
  " (in 'zibellreg', line 127, column 11 to column 12)",
  " (in 'zibellreg', line 127, column 4 to column 20)",
  " (in 'zibellreg', line 128, column 11 to column 12)",
  " (in 'zibellreg', line 128, column 4 to column 26)",
  " (in 'zibellreg', line 129, column 11 to column 12)",
  " (in 'zibellreg', line 129, column 4 to column 27)",
  " (in 'zibellreg', line 130, column 11 to column 12)",
  " (in 'zibellreg', line 130, column 4 to column 44)",
  " (in 'zibellreg', line 131, column 11 to column 12)",
  " (in 'zibellreg', line 131, column 4 to column 47)",
  " (in 'zibellreg', line 132, column 10 to column 11)",
  " (in 'zibellreg', line 132, column 4 to column 24)",
  " (in 'zibellreg', line 134, column 6 to column 35)",
  " (in 'zibellreg', line 135, column 6 to column 35)",
  " (in 'zibellreg', line 139, column 8 to column 77)",
  " (in 'zibellreg', line 138, column 11 to line 140, column 7)",
  " (in 'zibellreg', line 137, column 8 to column 120)",
  " (in 'zibellreg', line 136, column 19 to line 138, column 7)",
  " (in 'zibellreg', line 136, column 6 to line 140, column 7)",
  " (in 'zibellreg', line 133, column 17 to line 141, column 5)",
  " (in 'zibellreg', line 133, column 4 to line 141, column 5)",
  " (in 'zibellreg', line 142, column 2 to column 15)",
  " (in 'zibellreg', line 125, column 105 to line 143, column 1)"};
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
inv_logit2(const T0__& lp_arg__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bell(const T0__& lp_arg__, const int& link, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bern(const T0__& lp_arg__, const int& link, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_stan_scalar<T0__>>* = nullptr>
stan::promote_args_t<T0__> lambertW(const T0__& x, std::ostream* pstream__);
double bellnumber(const int& n, std::ostream* pstream__);
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>* = nullptr>
stan::promote_args_t<T1__>
bell_lpmf(const int& x, const T1__& theta, std::ostream* pstream__);
template <typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>* = nullptr>
stan::promote_args_t<T1__>
loglik_bell(const std::vector<int>& x, const std::vector<T1__>& theta,
            std::ostream* pstream__);
template <typename T1__, typename T2__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>>,-1,1>
loglik_bellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
               beta_arg__, const int& link, std::ostream* pstream__);
template <typename T1__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_col_vector<T4__>,
                              stan::is_vt_not_complex<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>,
                stan::base_type_t<T4__>>,-1,1>
loglik_zibellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
                 Z_arg__, const T3__& beta_arg__, const T4__& psi_arg__,
                 const int& link1, const int& link2, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
inv_logit2(const T0__& lp_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 56;
    n = stan::math::num_elements(lp);
    current_statement__ = 57;
    stan::math::validate_non_negative_index("x", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> x =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 61;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 59;
      stan::model::assign(x, (1 / (1 +
        stan::math::exp(
          -stan::model::rvalue(lp, "lp", stan::model::index_uni(i))))),
        "assigning variable x", stan::model::index_uni(i));
    }
    current_statement__ = 62;
    return x;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bell(const T0__& lp_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 70;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 69;
      return stan::math::exp(lp);
    } else {
      current_statement__ = 68;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 67;
        return lp;
      } else {
        current_statement__ = 66;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 65;
          return stan::math::square(lp);
        } else {
          current_statement__ = 64;
          std::stringstream errmsg_stream__;
          stan::math::stan_print(&errmsg_stream__, "Invalid link");
          throw std::domain_error(errmsg_stream__.str());
        }
      }
    }
    current_statement__ = 71;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bern(const T0__& lp_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 81;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 80;
      return inv_logit2(lp, pstream__);
    } else {
      current_statement__ = 79;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 78;
        return stan::math::Phi(lp);
      } else {
        current_statement__ = 77;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 76;
          return stan::math::inv_cloglog(lp);
        } else {
          current_statement__ = 75;
          if (stan::math::logical_eq(link, 4)) {
            current_statement__ = 74;
            return stan::math::add(
                     stan::math::divide(stan::math::atan(lp),
                       stan::math::pi()), 0.5);
          } else {
            current_statement__ = 73;
            std::stringstream errmsg_stream__;
            stan::math::stan_print(&errmsg_stream__, "Invalid link");
            throw std::domain_error(errmsg_stream__.str());
          }
        }
      }
    }
    current_statement__ = 82;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, stan::require_all_t<stan::is_stan_scalar<T0__>>*>
stan::promote_args_t<T0__> lambertW(const T0__& x, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ y = DUMMY_VAR__;
    local_scalar_t__ w = DUMMY_VAR__;
    current_statement__ = 86;
    y = stan::math::sqrt((1 + (stan::math::exp(1) * x)));
    current_statement__ = 87;
    w = (-1 + (2.036 *
      stan::math::log(((1 + (1.14956131 * y)) / (1 + (0.45495740 *
        stan::math::log((1 + y))))))));
    current_statement__ = 88;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 89;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 90;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 91;
    return w;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
double bellnumber(const int& n, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 113;
    if (stan::math::logical_lt(n, 2)) {
      current_statement__ = 111;
      return 1;
    } else {
      int k = std::numeric_limits<int>::min();
      current_statement__ = 94;
      stan::math::validate_non_negative_index("B", "n", n);
      Eigen::Matrix<local_scalar_t__,-1,1> B =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("Bneu", "n", n);
      Eigen::Matrix<local_scalar_t__,-1,1> Bneu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 98;
      stan::model::assign(B, 1, "assigning variable B",
        stan::model::index_uni(1));
      current_statement__ = 108;
      for (int i = 1; i <= (n - 1); ++i) {
        current_statement__ = 99;
        k = i;
        current_statement__ = 100;
        stan::model::assign(Bneu,
          stan::model::rvalue(B, "B", stan::model::index_uni(i)),
          "assigning variable Bneu", stan::model::index_uni(1));
        current_statement__ = 103;
        for (int j = 2; j <= (i + 1); ++j) {
          current_statement__ = 101;
          stan::model::assign(Bneu,
            (stan::model::rvalue(B, "B", stan::model::index_uni((j - 1))) +
            stan::model::rvalue(Bneu, "Bneu", stan::model::index_uni((j - 1)))),
            "assigning variable Bneu", stan::model::index_uni(j));
        }
        current_statement__ = 106;
        for (int j = 1; j <= n; ++j) {
          current_statement__ = 104;
          stan::model::assign(B,
            stan::model::rvalue(Bneu, "Bneu", stan::model::index_uni(j)),
            "assigning variable B", stan::model::index_uni(j));
        }
      }
      current_statement__ = 109;
      return stan::model::rvalue(Bneu, "Bneu",
               stan::model::index_uni((k + 1)));
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>*>
stan::promote_args_t<T1__>
bell_lpmf(const int& x, const T1__& theta, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  int current_statement__ = 0;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ Bx = DUMMY_VAR__;
    local_scalar_t__ lprob = DUMMY_VAR__;
    current_statement__ = 117;
    Bx = bellnumber(x, pstream__);
    current_statement__ = 118;
    lprob = (((((x * stan::math::log(theta)) - stan::math::exp(theta)) + 1) +
      stan::math::log(Bx)) - stan::math::lgamma((x + 1)));
    current_statement__ = 119;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, stan::require_all_t<stan::is_stan_scalar<T1__>>*>
stan::promote_args_t<T1__>
loglik_bell(const std::vector<int>& x, const std::vector<T1__>& theta,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 121;
    stan::math::validate_non_negative_index("lprob", "num_elements(x)",
      stan::math::num_elements(x));
    std::vector<local_scalar_t__> lprob =
      std::vector<local_scalar_t__>(stan::math::num_elements(x), DUMMY_VAR__);
    current_statement__ = 125;
    for (int i = 1; i <= stan::math::num_elements(x); ++i) {
      current_statement__ = 123;
      stan::model::assign(lprob,
        ((stan::model::rvalue(x, "x", stan::model::index_uni(i)) *
        stan::math::log(
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)))) -
        stan::math::exp(
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)))),
        "assigning variable lprob", stan::model::index_uni(i));
    }
    current_statement__ = 126;
    return stan::math::sum(lprob);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>>,-1,1>
loglik_bellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
               beta_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& X = stan::math::to_ref(X_arg__);
  const auto& beta = stan::math::to_ref(beta_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 128;
    n = stan::math::num_elements(y);
    current_statement__ = 129;
    stan::math::validate_non_negative_index("lprob", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lprob =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 131;
    stan::math::validate_non_negative_index("lp", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 132;
    stan::model::assign(lp, stan::math::multiply(X, beta),
      "assigning variable lp");
    current_statement__ = 133;
    stan::math::validate_non_negative_index("mu", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> mu =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 134;
    stan::model::assign(mu, linkinv_bell(lp, link, pstream__),
      "assigning variable mu");
    current_statement__ = 135;
    stan::math::validate_non_negative_index("theta", "n", n);
    std::vector<local_scalar_t__> theta =
      std::vector<local_scalar_t__>(n, DUMMY_VAR__);
    current_statement__ = 140;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 137;
      stan::model::assign(theta,
        stan::math::lambert_w0(
          stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
        "assigning variable theta", stan::model::index_uni(i));
      current_statement__ = 138;
      stan::model::assign(lprob,
        bell_lpmf<false>(
          stan::model::rvalue(y, "y", stan::model::index_uni(i)),
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
          pstream__), "assigning variable lprob", stan::model::index_uni(i));
    }
    current_statement__ = 141;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_col_vector<T4__>,
                              stan::is_vt_not_complex<T4__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>,
                stan::base_type_t<T4__>>,-1,1>
loglik_zibellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
                 Z_arg__, const T3__& beta_arg__, const T4__& psi_arg__,
                 const int& link1, const int& link2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>,
                             stan::base_type_t<T3__>,
                             stan::base_type_t<T4__>>;
  int current_statement__ = 0;
  const auto& X = stan::math::to_ref(X_arg__);
  const auto& Z = stan::math::to_ref(Z_arg__);
  const auto& beta = stan::math::to_ref(beta_arg__);
  const auto& psi = stan::math::to_ref(psi_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 143;
    n = stan::math::num_elements(y);
    current_statement__ = 144;
    stan::math::validate_non_negative_index("lprob", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lprob =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 146;
    stan::math::validate_non_negative_index("lp1", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp1 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 147;
    stan::model::assign(lp1, stan::math::multiply(Z, psi),
      "assigning variable lp1");
    current_statement__ = 148;
    stan::math::validate_non_negative_index("lp2", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp2 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 149;
    stan::model::assign(lp2, stan::math::multiply(X, beta),
      "assigning variable lp2");
    current_statement__ = 150;
    stan::math::validate_non_negative_index("mu", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> mu =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 151;
    stan::model::assign(mu, linkinv_bell(lp2, link2, pstream__),
      "assigning variable mu");
    current_statement__ = 152;
    stan::math::validate_non_negative_index("omega", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> omega =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 153;
    stan::model::assign(omega, linkinv_bern(lp1, link1, pstream__),
      "assigning variable omega");
    current_statement__ = 154;
    stan::math::validate_non_negative_index("theta", "n", n);
    std::vector<local_scalar_t__> theta =
      std::vector<local_scalar_t__>(n, DUMMY_VAR__);
    current_statement__ = 164;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 156;
      stan::model::assign(omega,
        stan::math::inv_logit(
          stan::model::rvalue(lp1, "lp1", stan::model::index_uni(i))),
        "assigning variable omega", stan::model::index_uni(i));
      current_statement__ = 157;
      stan::model::assign(theta,
        stan::math::lambert_w0(
          stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
        "assigning variable theta", stan::model::index_uni(i));
      current_statement__ = 162;
      if (stan::math::logical_eq(
            stan::model::rvalue(y, "y", stan::model::index_uni(i)), 0)) {
        current_statement__ = 160;
        stan::model::assign(lprob,
          stan::math::log_sum_exp(
            stan::math::bernoulli_lpmf<false>(1,
              stan::model::rvalue(omega, "omega", stan::model::index_uni(i))),
            (stan::math::bernoulli_lpmf<false>(0,
               stan::model::rvalue(omega, "omega", stan::model::index_uni(i)))
            +
            bell_lpmf<false>(
              stan::model::rvalue(y, "y", stan::model::index_uni(i)),
              stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
              pstream__))), "assigning variable lprob",
          stan::model::index_uni(i));
      } else {
        current_statement__ = 158;
        stan::model::assign(lprob,
          (stan::math::bernoulli_lpmf<false>(0,
             stan::model::rvalue(omega, "omega", stan::model::index_uni(i)))
          +
          bell_lpmf<false>(
            stan::model::rvalue(y, "y", stan::model::index_uni(i)),
            stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
            pstream__)), "assigning variable lprob",
          stan::model::index_uni(i));
      }
    }
    current_statement__ = 165;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_zibellreg final : public model_base_crtp<model_zibellreg> {
private:
  int n;
  int p;
  int q;
  std::vector<int> y;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,-1> Z_data__;
  int link1;
  int link2;
  Eigen::Matrix<double,1,-1> x_mean_data__;
  Eigen::Matrix<double,-1,1> x_sd_data__;
  Eigen::Matrix<double,1,-1> z_mean_data__;
  Eigen::Matrix<double,-1,1> z_sd_data__;
  int approach;
  double mu_beta;
  double sigma_beta;
  double mu_psi;
  double sigma_psi;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Z{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,1,-1>> x_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> x_sd{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,1,-1>> z_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> z_sd{nullptr, 0};
public:
  ~model_zibellreg() {}
  model_zibellreg(stan::io::var_context& context__, unsigned int
                  random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_zibellreg_namespace::model_zibellreg";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 25;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 25;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 25;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 26;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 26;
      stan::math::check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 27;
      context__.validate_dims("data initialization", "q", "int",
        std::vector<size_t>{});
      q = std::numeric_limits<int>::min();
      current_statement__ = 27;
      q = context__.vals_i("q")[(1 - 1)];
      current_statement__ = 27;
      stan::math::check_greater_or_equal(function__, "q", q, 0);
      current_statement__ = 28;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      y = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 29;
      y = context__.vals_i("y");
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 30;
      stan::math::validate_non_negative_index("X", "n", n);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(p)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, p,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), n, p);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 32;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 32;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 32;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 32;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 33;
      stan::math::validate_non_negative_index("Z", "n", n);
      current_statement__ = 34;
      stan::math::validate_non_negative_index("Z", "q", q);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "Z", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(q)});
      Z_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, q,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Z) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Z_data__.data(), n, q);
      {
        std::vector<local_scalar_t__> Z_flat__;
        current_statement__ = 35;
        Z_flat__ = context__.vals_r("Z");
        current_statement__ = 35;
        pos__ = 1;
        current_statement__ = 35;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 35;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 35;
            stan::model::assign(Z, Z_flat__[(pos__ - 1)],
              "assigning variable Z", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 35;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 36;
      context__.validate_dims("data initialization", "link1", "int",
        std::vector<size_t>{});
      link1 = std::numeric_limits<int>::min();
      current_statement__ = 36;
      link1 = context__.vals_i("link1")[(1 - 1)];
      current_statement__ = 37;
      context__.validate_dims("data initialization", "link2", "int",
        std::vector<size_t>{});
      link2 = std::numeric_limits<int>::min();
      current_statement__ = 37;
      link2 = context__.vals_i("link2")[(1 - 1)];
      current_statement__ = 38;
      stan::math::validate_non_negative_index("x_mean", "p", p);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "x_mean", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      x_mean_data__ = Eigen::Matrix<double,1,-1>::Constant(p,
                        std::numeric_limits<double>::quiet_NaN());
      new (&x_mean)
        Eigen::Map<Eigen::Matrix<double,1,-1>>(x_mean_data__.data(), p);
      {
        std::vector<local_scalar_t__> x_mean_flat__;
        current_statement__ = 39;
        x_mean_flat__ = context__.vals_r("x_mean");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 39;
          stan::model::assign(x_mean, x_mean_flat__[(pos__ - 1)],
            "assigning variable x_mean", stan::model::index_uni(sym1__));
          current_statement__ = 39;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 40;
      stan::math::validate_non_negative_index("x_sd", "p", p);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "x_sd", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      x_sd_data__ = Eigen::Matrix<double,-1,1>::Constant(p,
                      std::numeric_limits<double>::quiet_NaN());
      new (&x_sd) Eigen::Map<Eigen::Matrix<double,-1,1>>(x_sd_data__.data(),
        p);
      {
        std::vector<local_scalar_t__> x_sd_flat__;
        current_statement__ = 41;
        x_sd_flat__ = context__.vals_r("x_sd");
        current_statement__ = 41;
        pos__ = 1;
        current_statement__ = 41;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 41;
          stan::model::assign(x_sd, x_sd_flat__[(pos__ - 1)],
            "assigning variable x_sd", stan::model::index_uni(sym1__));
          current_statement__ = 41;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 41;
      stan::math::check_greater_or_equal(function__, "x_sd", x_sd, 0);
      current_statement__ = 42;
      stan::math::validate_non_negative_index("z_mean", "q", q);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "z_mean", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      z_mean_data__ = Eigen::Matrix<double,1,-1>::Constant(q,
                        std::numeric_limits<double>::quiet_NaN());
      new (&z_mean)
        Eigen::Map<Eigen::Matrix<double,1,-1>>(z_mean_data__.data(), q);
      {
        std::vector<local_scalar_t__> z_mean_flat__;
        current_statement__ = 43;
        z_mean_flat__ = context__.vals_r("z_mean");
        current_statement__ = 43;
        pos__ = 1;
        current_statement__ = 43;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 43;
          stan::model::assign(z_mean, z_mean_flat__[(pos__ - 1)],
            "assigning variable z_mean", stan::model::index_uni(sym1__));
          current_statement__ = 43;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 44;
      stan::math::validate_non_negative_index("z_sd", "q", q);
      current_statement__ = 45;
      context__.validate_dims("data initialization", "z_sd", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      z_sd_data__ = Eigen::Matrix<double,-1,1>::Constant(q,
                      std::numeric_limits<double>::quiet_NaN());
      new (&z_sd) Eigen::Map<Eigen::Matrix<double,-1,1>>(z_sd_data__.data(),
        q);
      {
        std::vector<local_scalar_t__> z_sd_flat__;
        current_statement__ = 45;
        z_sd_flat__ = context__.vals_r("z_sd");
        current_statement__ = 45;
        pos__ = 1;
        current_statement__ = 45;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 45;
          stan::model::assign(z_sd, z_sd_flat__[(pos__ - 1)],
            "assigning variable z_sd", stan::model::index_uni(sym1__));
          current_statement__ = 45;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 45;
      stan::math::check_greater_or_equal(function__, "z_sd", z_sd, 0);
      current_statement__ = 46;
      context__.validate_dims("data initialization", "approach", "int",
        std::vector<size_t>{});
      approach = std::numeric_limits<int>::min();
      current_statement__ = 46;
      approach = context__.vals_i("approach")[(1 - 1)];
      current_statement__ = 46;
      stan::math::check_greater_or_equal(function__, "approach", approach, 0);
      current_statement__ = 46;
      stan::math::check_less_or_equal(function__, "approach", approach, 1);
      current_statement__ = 47;
      context__.validate_dims("data initialization", "mu_beta", "double",
        std::vector<size_t>{});
      mu_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 47;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization", "sigma_beta", "double",
        std::vector<size_t>{});
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 48;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "sigma_beta",
        sigma_beta, 0);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "mu_psi", "double",
        std::vector<size_t>{});
      mu_psi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 49;
      mu_psi = context__.vals_r("mu_psi")[(1 - 1)];
      current_statement__ = 50;
      context__.validate_dims("data initialization", "sigma_psi", "double",
        std::vector<size_t>{});
      sigma_psi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 50;
      sigma_psi = context__.vals_r("sigma_psi")[(1 - 1)];
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "sigma_psi", sigma_psi,
        0);
      current_statement__ = 51;
      stan::math::validate_non_negative_index("psi_std", "q", q);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("beta_std", "p", p);
      current_statement__ = 53;
      stan::math::validate_non_negative_index("psi", "q", q);
      current_statement__ = 54;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("log_lik", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = q + p;
  }
  inline std::string model_name() const final {
    return "model_zibellreg";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_zibellreg_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> psi_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 1;
      psi_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(q);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 2;
      beta_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      Eigen::Matrix<local_scalar_t__,-1,1> psi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 11;
      if (stan::math::logical_eq(p, 1)) {
        current_statement__ = 9;
        stan::model::assign(beta,
          (stan::model::rvalue(beta_std, "beta_std",
             stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))),
          "assigning variable beta", stan::model::index_uni(1));
      } else {
        current_statement__ = 6;
        stan::model::assign(beta,
          stan::math::elt_divide(
            stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(x_sd, "x_sd",
              stan::model::index_min_max(2, p))), "assigning variable beta",
          stan::model::index_min_max(2, p));
        current_statement__ = 7;
        stan::model::assign(beta,
          ((stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(x_mean, "x_mean",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(beta, "beta",
              stan::model::index_min_max(2, p)))), "assigning variable beta",
          stan::model::index_uni(1));
      }
      current_statement__ = 17;
      if (stan::math::logical_eq(q, 1)) {
        current_statement__ = 15;
        stan::model::assign(psi,
          (stan::model::rvalue(psi_std, "psi_std", stan::model::index_uni(1))
          / stan::model::rvalue(z_sd, "z_sd", stan::model::index_uni(1))),
          "assigning variable psi", stan::model::index_uni(1));
      } else {
        current_statement__ = 12;
        stan::model::assign(psi,
          stan::math::elt_divide(
            stan::model::rvalue(psi_std, "psi_std",
              stan::model::index_min_max(2, q)),
            stan::model::rvalue(z_sd, "z_sd",
              stan::model::index_min_max(2, q))), "assigning variable psi",
          stan::model::index_min_max(2, q));
        current_statement__ = 13;
        stan::model::assign(psi,
          ((stan::model::rvalue(psi_std, "psi_std", stan::model::index_uni(1))
          / stan::model::rvalue(z_sd, "z_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(z_mean, "z_mean",
              stan::model::index_min_max(2, q)),
            stan::model::rvalue(psi, "psi", stan::model::index_min_max(2, q)))),
          "assigning variable psi", stan::model::index_uni(1));
      }
      {
        current_statement__ = 18;
        stan::math::validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> loglik =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 19;
        stan::model::assign(loglik,
          loglik_zibellreg(y, X, Z, beta_std, psi_std, link1, link2,
            pstream__), "assigning variable loglik");
        current_statement__ = 20;
        lp_accum__.add(stan::math::sum(loglik));
        current_statement__ = 24;
        if (stan::math::logical_eq(approach, 1)) {
          current_statement__ = 21;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(beta_std, mu_beta,
                           sigma_beta));
          current_statement__ = 22;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(psi_std, mu_psi,
                           sigma_psi));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_zibellreg_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> psi_std =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      psi_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(q);
      Eigen::Matrix<double,-1,1> beta_std =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      Eigen::Matrix<double,-1,1> psi =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(psi_std);
      out__.write(beta_std);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 11;
      if (stan::math::logical_eq(p, 1)) {
        current_statement__ = 9;
        stan::model::assign(beta,
          (stan::model::rvalue(beta_std, "beta_std",
             stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))),
          "assigning variable beta", stan::model::index_uni(1));
      } else {
        current_statement__ = 6;
        stan::model::assign(beta,
          stan::math::elt_divide(
            stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(x_sd, "x_sd",
              stan::model::index_min_max(2, p))), "assigning variable beta",
          stan::model::index_min_max(2, p));
        current_statement__ = 7;
        stan::model::assign(beta,
          ((stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(x_mean, "x_mean",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(beta, "beta",
              stan::model::index_min_max(2, p)))), "assigning variable beta",
          stan::model::index_uni(1));
      }
      current_statement__ = 17;
      if (stan::math::logical_eq(q, 1)) {
        current_statement__ = 15;
        stan::model::assign(psi,
          (stan::model::rvalue(psi_std, "psi_std", stan::model::index_uni(1))
          / stan::model::rvalue(z_sd, "z_sd", stan::model::index_uni(1))),
          "assigning variable psi", stan::model::index_uni(1));
      } else {
        current_statement__ = 12;
        stan::model::assign(psi,
          stan::math::elt_divide(
            stan::model::rvalue(psi_std, "psi_std",
              stan::model::index_min_max(2, q)),
            stan::model::rvalue(z_sd, "z_sd",
              stan::model::index_min_max(2, q))), "assigning variable psi",
          stan::model::index_min_max(2, q));
        current_statement__ = 13;
        stan::model::assign(psi,
          ((stan::model::rvalue(psi_std, "psi_std", stan::model::index_uni(1))
          / stan::model::rvalue(z_sd, "z_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(z_mean, "z_mean",
              stan::model::index_min_max(2, q)),
            stan::model::rvalue(psi, "psi", stan::model::index_min_max(2, q)))),
          "assigning variable psi", stan::model::index_uni(1));
      }
      if (emit_transformed_parameters__) {
        out__.write(psi);
        out__.write(beta);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      stan::model::assign(log_lik,
        loglik_zibellreg(y, X, Z, beta_std, psi_std, link1, link2, pstream__),
        "assigning variable log_lik");
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> psi_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(psi_std,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(q),
        "assigning variable psi_std");
      out__.write(psi_std);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta_std,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta_std");
      out__.write(beta_std);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "psi_std",
        "double", std::vector<size_t>{static_cast<size_t>(q)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta_std",
        "double", std::vector<size_t>{static_cast<size_t>(p)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> psi_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> psi_std_flat__;
        current_statement__ = 1;
        psi_std_flat__ = context__.vals_r("psi_std");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(psi_std, psi_std_flat__[(pos__ - 1)],
            "assigning variable psi_std", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(psi_std);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_std_flat__;
        current_statement__ = 2;
        beta_std_flat__ = context__.vals_r("beta_std");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(beta_std, beta_std_flat__[(pos__ - 1)],
            "assigning variable beta_std", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta_std);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"psi_std", "beta_std"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"psi", "beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(q)},
                std::vector<size_t>{static_cast<size_t>(p)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(q)},
             std::vector<size_t>{static_cast<size_t>(p)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "psi_std" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_std" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "psi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "psi_std" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_std" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "psi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"psi_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"beta_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"psi_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"beta_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (q + p);
    const size_t num_transformed = emit_transformed_parameters * ((q + p));
    const size_t num_gen_quantities = emit_generated_quantities * (n);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (q + p);
    const size_t num_transformed = emit_transformed_parameters * ((q + p));
    const size_t num_gen_quantities = emit_generated_quantities * (n);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_zibellreg_namespace::model_zibellreg;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_zibellreg_namespace::profiles__;
}
#endif
#endif
