% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{extract_log_lik}
\alias{extract_log_lik}
\alias{extract_log_lik.bellreg}
\title{Extract pointwise log-likelihood from a Stan model for a bellreg model}
\usage{
extract_log_lik(object, ...)
}
\arguments{
\item{object}{an object of the class bellreg.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix with the pointwise extracted log-likelihood associated with a bellreg model.
}
\description{
This function extracts the pointwise log-likelihood for a bellreg model.
}
\examples{
\donttest{
data(faults)
fit <- bellreg(nf ~ lroll, data = faults, approach = "bayes")
loglik <- extract_log_lik(fit)

data(cells)
fit <- zibellreg(cells ~ 1|smoker+gender, data = cells, approach = "bayes", chains = 1, iter = 100)
loglik <- extract_log_lik(fit)

}

}
