% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_operators.R
\name{create_beast2_input_operators}
\alias{create_beast2_input_operators}
\title{Creates the operators section of a BEAST2 XML parameter file}
\usage{
create_beast2_input_operators(site_models, clock_models, tree_priors,
  fixed_crown_ages = rep(FALSE, length(site_models)), mrca_priors = NA,
  tipdates_filename = NA)
}
\arguments{
\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{fixed_crown_ages}{one or more booleans to determine if the
phylogenies' crown ages are fixed.
If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
lines of XML text
}
\description{
Creates the operators section of a BEAST2 XML parameter file
}
\author{
Richèl J.C. Bilderbeek
}
