% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tree_prior.R
\name{check_tree_prior}
\alias{check_tree_prior}
\title{Check if the tree prior is a valid tree prior}
\usage{
check_tree_prior(tree_prior)
}
\arguments{
\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the tree priors are invalid
}
\examples{
 testthat::expect_silent(check_tree_prior(create_yule_tree_prior()))
 testthat::expect_silent(check_tree_prior(create_bd_tree_prior()))
 testthat::expect_silent(check_tree_prior(create_cbs_tree_prior()))
 testthat::expect_silent(check_tree_prior(create_ccp_tree_prior()))
 testthat::expect_silent(check_tree_prior(create_cep_tree_prior()))

 # Can use list of one tree prior
 testthat::expect_silent(check_tree_prior(list(create_yule_tree_prior())))

 # List of two tree priors is not a/one tree prior
 testthat::expect_error(
   check_tree_prior(
     list(create_yule_tree_prior(), create_yule_tree_prior())
   )
 )

 # Must stop on non-tree priors
 testthat::expect_error(check_tree_prior(tree_prior = "nonsense"))
 testthat::expect_error(check_tree_prior(tree_prior = NULL))
 testthat::expect_error(check_tree_prior(tree_prior = NA))
}
\seealso{
Use \link{create_tree_prior} to create a valid tree prior
}
\author{
Richèl J.C. Bilderbeek
}
