% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_clock_models.R
\name{check_clock_models}
\alias{check_clock_models}
\title{Check if the object is a list of one or more clock models.}
\usage{
check_clock_models(clock_models)
}
\arguments{
\item{clock_models}{the object to be checked if it is a list of one
or more valid clock models}
}
\value{
nothing.
  Will \link{stop} if the object is not a list of one or more clock models.
}
\description{
Will \link{stop} if the object is not a list of one or more clock models.
}
\examples{
  testthat::expect_silent(check_clock_models(create_strict_clock_model()))
  testthat::expect_silent(
    check_clock_models(list(create_strict_clock_model()))
  )
  testthat::expect_silent(
    check_clock_models(
      list(create_strict_clock_model(), create_rln_clock_model())
    )
  )

  testthat::expect_error(check_clock_models("nonsense"))
  testthat::expect_error(check_clock_models(3.14))
  testthat::expect_error(check_clock_models(42))
  testthat::expect_error(check_clock_models(NA))
  testthat::expect_error(check_clock_models(NULL))
}
\seealso{
Use \link{create_clock_model} to create a valid clock model
}
\author{
Richèl J.C. Bilderbeek
}
