% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_os.R
\name{check_os}
\alias{check_os}
\title{Checks if the operating system is supported}
\usage{
check_os(os)
}
\arguments{
\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
nothing. Will stop if the OS is unsupported
}
\description{
Checks if the operating system is supported
}
\examples{
  library(testthat)

  expect_silent(check_os("mac"))
  expect_silent(check_os("unix"))
  expect_silent(check_os("win"))

  expect_error(check_os("android"))
  expect_error(check_os("n64"))
  expect_error(check_os("nds"))
  expect_error(check_os("nes"))
  expect_error(check_os("snes"))

  expect_error(check_os(NA))
  expect_error(check_os(NULL))
  expect_error(check_os(""))
  expect_error(check_os(c()))
}
\author{
Richèl J.C. Bilderbeek
}
