% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{r.gailsimon}
\alias{r.gailsimon}
\title{Gail-Simon Test}
\usage{
r.gailsimon(effects, sderr, d = 0)
}
\arguments{
\item{effects}{subgroup treatment effects}

\item{sderr}{standard deviation of the estimated treatment effects}

\item{d}{clinically meaningful difference}
}
\description{
Gail-Simon qualitative interaction test.
}
\examples{
\dontrun{
var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
subgrp.effect <- r.get.subgrp.raw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);

gs.pval <- r.gailsimon(subgrp.effect$Estimate,
                       subgrp.effect$Variance); }


}

