% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fcs.R
\name{as_data_frame_flow_frame}
\alias{as_data_frame_flow_frame}
\title{Cast \code{flowFrame} to \code{data_frame}.}
\usage{
as_data_frame_flow_frame(.flow_frame, .channels = NULL)
}
\arguments{
\item{.flow_frame}{A \code{flowFrame}. Usually the result of \code{read.FCS} from \code{flowCore}.}

\item{.channels}{A character vector with the event channels to extract. Default is all channels.}
}
\value{
A \code{data_frame}
}
\description{
Extracts the flow events from the \code{flowFrame} as a \code{data_frame}
}
\examples{
\dontrun{
library(beadplexr)
library(flowCore)
.file_name <- system.file("extdata", "K2-C07-A7.fcs",
                          package = "beadplexr")
# Load the fcs file
.flow_frame <- read.FCS(filename = .file_name,
                        transformation = FALSE)

# Get all channels
as_data_frame_flow_frame(.flow_frame)

# Just interesting
as_data_frame_flow_frame(.flow_frame,
                         .channels = c("FSC-A", "SSC-A",
                                       "FL2-H", "FL6-H"))
}
}
\keyword{internal}
