% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorFactory.R
\name{ExtractorFactory}
\alias{ExtractorFactory}
\title{Class to handle the creation of Instance types}
\description{
\code{\link{ExtractorFactory}} class builds the appropriate
\code{\link{Instance}} object according to the file extension. In the case
of not finding the registered extension, the default extractor will be used
if it has been previously configured.
}
\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtractorFactory-new}{\code{ExtractorFactory$new()}}
\item \href{#method-ExtractorFactory-registerExtractor}{\code{ExtractorFactory$registerExtractor()}}
\item \href{#method-ExtractorFactory-setExtractor}{\code{ExtractorFactory$setExtractor()}}
\item \href{#method-ExtractorFactory-setDefaultExtractor}{\code{ExtractorFactory$setDefaultExtractor()}}
\item \href{#method-ExtractorFactory-removeExtractor}{\code{ExtractorFactory$removeExtractor()}}
\item \href{#method-ExtractorFactory-getAllExtractors}{\code{ExtractorFactory$getAllExtractors()}}
\item \href{#method-ExtractorFactory-getDefaultExtractor}{\code{ExtractorFactory$getDefaultExtractor()}}
\item \href{#method-ExtractorFactory-isSpecificExtractor}{\code{ExtractorFactory$isSpecificExtractor()}}
\item \href{#method-ExtractorFactory-createInstance}{\code{ExtractorFactory$createInstance()}}
\item \href{#method-ExtractorFactory-reset}{\code{ExtractorFactory$reset()}}
\item \href{#method-ExtractorFactory-print}{\code{ExtractorFactory$print()}}
\item \href{#method-ExtractorFactory-clone}{\code{ExtractorFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorFactory}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-registerExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-registerExtractor}{}}}
\subsection{Method \code{registerExtractor()}}{
Adds an extractor to the list of extensions. If the extension
is an empty string (""), the indicated extractor will be the default
when there is no extractor associated with an extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$registerExtractor(extensions, extractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extensions}}{A \code{\link{character}} array. The names of the
extension option.}

\item{\code{extractor}}{A \code{Object} value. The extractor of the new
extension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-setExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-setExtractor}{}}}
\subsection{Method \code{setExtractor()}}{
Modifies the extractor of the one extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$setExtractor(extension, extractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension option.}

\item{\code{extractor}}{A \code{Object} value. The value of the new
extractor.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-setDefaultExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-setDefaultExtractor}{}}}
\subsection{Method \code{setDefaultExtractor()}}{
Modifies the extractor of the one extension. Assign NULL
value to disable the default extractor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$setDefaultExtractor(defaultExtractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defaultExtractor}}{A \code{Object} value. The value of the default
extractor.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-removeExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-removeExtractor}{}}}
\subsection{Method \code{removeExtractor()}}{
Removes a specific extractor thought the extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$removeExtractor(extension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension to remove.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-getAllExtractors"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-getAllExtractors}{}}}
\subsection{Method \code{getAllExtractors()}}{
Gets the list of extractors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$getAllExtractors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of extractors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-getDefaultExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-getDefaultExtractor}{}}}
\subsection{Method \code{getDefaultExtractor()}}{
Gets the default extractor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$getDefaultExtractor()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of default extractor.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-isSpecificExtractor"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-isSpecificExtractor}{}}}
\subsection{Method \code{isSpecificExtractor()}}{
Checks if exists an extractor for a specific extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$isSpecificExtractor(extension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extension}}{A \code{\link{character}} value. The name of the
extension to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of extractors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-createInstance"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-createInstance}{}}}
\subsection{Method \code{createInstance()}}{
Builds the \code{\link{Instance}} object according to the
file extension. In the case of not finding the registered extension, the
default extractor will be used if it has been previously configured.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$createInstance(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the file to create
an \code{\link{Instance}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} corresponding object according to the
file extension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-reset"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-reset}{}}}
\subsection{Method \code{reset()}}{
Resets list of extractor to default state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-print"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-print}{}}}
\subsection{Method \code{print()}}{
Prints pipeline representation. (Override print function)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments passed to or from other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
