% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StopWordPipe.R
\docType{class}
\name{StopWordPipe}
\alias{StopWordPipe}
\title{Class to find and/or remove the stop words on the data field of an Instance}
\usage{
StopWordPipe
}
\description{
\code{\link{StopWordPipe}} class is responsible for detecting
the existing stop words in the \strong{data} field of each \code{\link{Instance}}.
Identified stop words are stored inside the \strong{contraction} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
stop words removement.
}
\section{Constructor}{

\preformatted{
StopWordPipe$new(propertyName = "stopWord",
                 propertyLanguageName = "language",
                 alwaysBeforeDeps = list("GuessLanguagePipe"),
                 notAfterDeps = list("AbbreviationPipe"),
                 removeStopWords = TRUE)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{propertyLanguageName:}}{
(\emph{character}) name of the language property.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{removeStopWords:}}{
(\emph{logical}) indicates if the stop words are removed or not.
}
}
}
}
}

\section{Details}{

\code{\link{StopWordPipe}} class requires the resource files (in json format)
containing the list of stop words. To this end, the language of the text
indicated in the \emph{propertyLanguageName} should be contained in the
resource file name (ie. xxx.json where xxx is the value defined in the
\emph{propertyLanguageName} ). The location of the resources should be
defined in the \strong{"resources.stopwords.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{StopWordPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/remove the stop words.
The stop words found in the pipe are added to the list of properties of
the \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findStopWord:}}{
checks if the stop word is in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findStopWord(data, stopWord)}
}
\item{\emph{Value:}}{
boolean, depending on whether the stop word is on the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text where stop words will be searched.
}
\item{\strong{stopWord:}}{
(\emph{character}) Indicates the stop word to find.
}
}
}
}
}

\item{\bold{removeStopWord:}}{
removes the stop word in the data.
\itemize{
\item{\emph{Usage:}}{
\code{removeStopWord(stopWord, data)}
}
\item{\emph{Value:}}{
the data with stop word removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{stopWord:}}{
(\emph{character}) indicates the stop word to remove.
}
\item{\strong{data:}}{
(\emph{character}) text where stop words will be removed.
}
}
}
}
}

\item{\bold{getPropertyLanguageName:}}{
gets of name of property language.
\itemize{
\item{\emph{Usage:}}{
\code{getPropertyLanguageName()}
}
\item{\emph{Value:}}{
value of name of property language.
}
}
}

\item{\bold{getPathResourcesStopWords:}}{
gets of path of stop words resources.
\itemize{
\item{\emph{Usage:}}{
\code{getPathResourcesStopWords()}
}
\item{\emph{Value:}}{
value of path of stop words resources.
}
}
}

\item{\bold{setPathResourcesStopWords:}}{
sets the path of stop words resources.
\itemize{
\item{\emph{Usage:}}{
\code{setPathResourcesStopWords(path)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) the new value of the path of stop words resources.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyLanguageName:}}{
 (\emph{character}) the name of property about language.
}
\item{\bold{pathResourcesStopWords:}}{
 (\emph{character}) the path where are the resources.
}
\item{\bold{removeStopWords:}}{
(\emph{logical}) indicates if the stop words are removed or not.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
