% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Instance.R
\docType{class}
\name{Instance}
\alias{Instance}
\title{Abstract super class that handles the management of the Instances}
\usage{
Instance
}
\description{
Provides the required methods to succesfully handle each
\code{\link{Instance}} class.
}
\section{Constructor}{

\code{Instance$new(path)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the file.
}
}
}
}
}

\section{Methods}{

\itemize{
\item{\bold{obtainDate:}}{
abstract function responsible for obtainining the date of the
\code{\link{Instance}}.
}
\item{\bold{obtainSource:}}{
abstract function in charge of determining the source of the
\code{\link{Instance}}.
}
\item{\bold{getDate:}}{
gets of date.
\itemize{
\item{\emph{Usage:}}{
\code{getDate()}
}
\item{\emph{Value:}}{
Value of date.
}
}
}

\item{\bold{setDate:}}{
sets of date.
\itemize{
\item{\emph{Usage:}}{
\code{setDate(date)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{date:}}{
(\emph{character}) the new value of date.
}
}
}
}
}

\item{\bold{getSource:}}{
gets of source.
\itemize{
\item{\emph{Usage:}}{
\code{getSource()}
}
\item{\emph{Value:}}{
value of source.
}
}
}

\item{\bold{setSource:}}{
modifies the source value.
\itemize{
\item{\emph{Usage:}}{
\code{setSource(source)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{source:}}{
(\emph{character}) the new value of source.
}
}
}
}
}

\item{\bold{getPath:}}{
gets of path.
\itemize{
\item{\emph{Usage:}}{
\code{getPath()}
}
\item{\emph{Value:}}{
value of path.
}
}
}

\item{\bold{getProperties:}}{
gets the list of properties.
\itemize{
\item{\emph{Usage:}}{
\code{getProperties()}
}
\item{\emph{Value:}}{
Value of properties.
}
}
}

\item{\bold{setProperties:}}{
modifies the list of properties.
\itemize{
\item{\emph{Usage:}}{
\code{setProperties(properties)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{properties:}}{
(\emph{list}) containing the new properties.
}
}
}
}
}

\item{\bold{addProperties:}}{
adds a property to the list of properties.
\itemize{
\item{\emph{Usage:}}{
\code{addProperties(propertyValue, propertyName)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyValue:}}{
(\emph{Object}) the value of the new property.
}
\item{\strong{propertyName:}}{
(\emph{character}) the name of the new property.
}
}
}
}
}

\item{\bold{getSpecificProperty:}}{
obtains a specific property.
\itemize{
\item{\emph{Usage:}}{
\code{getSpecificProperty(propertyName)}
}
\item{\emph{Value:}}{
the value of the specific property.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) the name of the property to obtain.
}
}
}
}
}

\item{\bold{isSpecificProperty:}}{
checks for the existence of an specific property.
\itemize{
\item{\emph{Usage:}}{
\code{isSpecificProperty(propertyName)}
}
\item{\emph{Value:}}{
A boolean results according to the existence of the specific property in the list of properties.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) the name of the property to check.
}
}
}
}
}

\item{\bold{setSpecificProperty:}}{
modifies the value of the one property.
\itemize{
\item{\emph{Usage:}}{
\code{setSpecificProperty(propertyName, propertyValue)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{Object}) the new value of the property.
}
\item{\strong{propertyValue:}}{
(\emph{character}) the name of the property.
}
}
}
}
}

\item{\bold{getNamesOfProperties:}}{
gets of the names of all properties.
\itemize{
\item{\emph{Usage:}}{
\code{getNamesOfProperties()}
}
\item{\emph{Value:}}{
the names of properties.
}
}
}

\item{\bold{isInstanceValid:}}{
checks if the \code{\link{Instance}} is valid.
\itemize{
\item{\emph{Usage:}}{
\code{isInstanceValid()}
}
\item{\emph{Value:}}{
value of isValid.
}
}
}

\item{\bold{invalidate:}}{
forces the invalidation of an specific \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{invalidate()}
}
}
}

\item{\bold{getFlowPipes:}}{
gets the list of the flow of Pipes.
\itemize{
\item{\emph{Usage:}}{
\code{getNamesOfProperties()}
}
\item{\emph{Value:}}{
names of the Pipes used.
}
}
}

\item{\bold{addFlowPipes:}}{
adds a new Pipe to the flow of Pipes.
\itemize{
\item{\emph{Usage:}}{
\code{addFlowPipes(namePipe)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{namePipe:}}{
(\emph{character}) name of the new Pipe to be added in the Pipe flow.
}
}
}
}
}

\item{\bold{getBanPipes:}}{
gets an array with contaning all the Pipes.
\itemize{
\item{\emph{Usage:}}{
\code{getBanPipes()}
}
\item{\emph{Value:}}{
value of Pipe ban array.
}
}
}

\item{\bold{addBanPipes:}}{
added the name of the Pipe to the array that keeps the track of Pipes having running after restrictions.
\itemize{
\item{\emph{Usage:}}{
\code{addBanPipes(namePipe)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{namePipe:}}{
(\emph{character}) Pipe name to be introduced into the ban array.
}
}
}
}
}

\item{\bold{checkCompatibility:}}{
Check compability between Pipes.
\itemize{
\item{\emph{Usage:}}{
\code{checkCompatibility(namePipe, alwaysBefore)}
}
\item{\emph{Value:}}{
boolean, depends if the compability between Pipes is correctly or not.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{namePipe:}}{
(\emph{character}) name of the Pipe to check the compatibility.
}
\item{\strong{alwaysBefore:}}{
(\emph{list}) pipes that the \code{Instance} had to go through.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{date:}}{
 (\emph{character}) the date on which the source was generated or sent.
}
\item{\bold{source:}}{
 (\emph{character}) the text of the file without modifications.
}
\item{\bold{path:}}{
 (\emph{character}) identifier of the \code{Instance}, in this case it will be the path of
 the file from which the properties are extracted.
}
\item{\bold{data:}}{
 (\emph{character}) the text of the file with modifications.
}
\item{\bold{properties:}}{
 (\emph{list}) contains a list of properties extracted from the text that is being
 processed.
}
\item{\bold{isValid:}}{
 (\emph{logical}) indicates if the \code{\link{Instance}} is valid or not.
}
\item{\bold{flowPipes:}}{
 (\emph{list}) the list contains the Pipes that the \code{Instance} has passed through.
}
\item{\bold{banPipes:}}{
 (\emph{array}) the list contains the Pipes that can not be executed from that moment.
}
}
}

