% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_panel_data.R
\name{get_panel_data}
\alias{get_panel_data}
\title{Get panel data by unit and variable Id's from BDL API}
\usage{
get_panel_data(unitId, varId, year = NULL, ggplot = FALSE, ...)
}
\arguments{
\item{unitId}{A single 12 character NUTS id code or vector of  multiple unit id 
codes. If multiple unit codes are used, some columns are not available.
Use \code{\link{search_units}} or \code{\link{get_units}} to find unit id code.}

\item{varId}{A single Id or vector of variable Id's.Use \code{\link{search_variables}} or
\code{\link{get_variables}} to find variable id code.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{ggplot}{Output in a long format suitable for ggplot2. Allows to plot results directly with ggplot function.}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve data for given units from BDL with specified format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be filtered with arguments. To get JSON data from specified
  directory with custom filters use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
   # get_panel_data(unitId = "030210101000", varId =  "60270")
   
   # get_panel_data(unitId = "030210101000", varId =  c("60270", "461668"))
   
   # get_panel_data(unitId = c("030210101000", "030210105000", "030210106000"), 
   #                varId =  c("60270", "461668"), year = c(2013:2016))
                          
   # get_panel_data(unitId = c("030210101000", "030210105000", "030210106000"), 
   #                varId =  c("60270", "461668"), ggplot = TRUE)
}
\keyword{database}
\keyword{utilities}
