% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-model.R
\name{run_model}
\alias{run_model}
\title{Run JAGS model for prepared species data}
\usage{
run_model(jags_data = NULL, model_file_path = NULL, inits = NULL,
  parameters_to_save = c("n"), track_n = TRUE, n_chains = 3,
  n_adapt = NULL, n_burnin = 20000, n_thin = 10,
  n_saved_steps = 2000, n_iter = 10000, parallel = FALSE,
  quiet = FALSE, modules = NULL, ...)
}
\arguments{
\item{jags_data}{List or environment containing the data to model, as output
by \code{prepare_jags_data}}

\item{model_file_path}{Path to custom model. Overrides the \code{model}
variable set by \code{prepare_jags_data}}

\item{inits}{Optional list of initialization values for JAGS model.
If none are specified, the JAGS model will generate its own
initial values.}

\item{parameters_to_save}{Character vector of parameters to monitor in JAGS. Defaults
to just monitoring "n"}

\item{track_n}{By default, the parameter "n" will always be tracked, even if the user
forgets to specify it. However, if the user is positive they do not want
to track "n", this parameter can be be set to \code{FALSE}. NOTE: you will
not be able to generate annual indices if "n" is not tracked.}

\item{n_chains}{Optional number of chains to run. Defaults to 3.}

\item{n_adapt}{Optional integer specifying the number of steps to
adapt the JAGS model.  The default is \code{NULL}, which will result in
the function running groups of 100 adaptation iterations (to amax of 10,000)
until JAGS reports adaptation is sufficient. If you set it manually,
1000 is the recommended minimum value.}

\item{n_burnin}{Optional integer specifying the number of iterations
to burn in the model. Defaults to 20000 per chain.}

\item{n_thin}{Optional number of steps to thin or discard.}

\item{n_saved_steps}{Optional number of steps to save per chain.
Defaults to 2000.}

\item{n_iter}{Optional number of iterations per chain. Defaults to 10000.}

\item{parallel}{Should each chain be run parallel on separate cores?
If TRUE, the number of cores used will be the minimum of the
\code{n_chains} specified and the number of cores on your computer}

\item{quiet}{Should JAGS output be suppressed?}

\item{modules}{Character vector of JAGS modules to load before analysis. By default no extra modules are loaded (other than 'basemod' and 'bugs'). To force glm or other modules to load, use modules = "glm". Be warned, our experience suggests that including the glm module may cause problems with the BBS data.}

\item{...}{Additional arguments}
}
\value{
jagsUI object
}
\description{
\code{run-model} runs a JAGS model as specified by the user for
  the species of interest
}
\examples{

# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# Now run a JAGS model. For the sake of speed, we've adjusted
#   some arguments so that the JAGS model will not run any
#   adaptation steps (n_adapt = 0), no burnin steps (n_burnin = 0),
#   only 50 iterations per chain (n_iter = 50), and will not
#   thin the chain (n_thin = 1). This will produce several convergence
#   warnings, but we can ignore them for the sake of this toy example.

jags_mod <- run_model(jags_data = jags_data,
                      n_adapt = 0,
                      n_burnin = 0,
                      n_iter = 10,
                      n_thin = 1,
                      parameters_to_save = c("n", "strata"))

}
