% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosteriorPredictive.GaussianGaussian}
\alias{rPosteriorPredictive.GaussianGaussian}
\title{Generate random samples from the posterior predictive distribution of a "GaussianGaussian" object}
\usage{
\method{rPosteriorPredictive}{GaussianGaussian}(obj, n = 1, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{n}{integer, number of samples.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix of n rows, each row is a sample.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{x \sim Gaussian(mu,Sigma)}
     \deqn{mu \sim Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "GaussianGaussian" object. \cr
Posterior predictive is a distribution of x|m,S,Sigma.
}
\examples{
obj <- GaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),m=c(0.2,0.5),S=diag(2)))
rPosteriorPredictive(obj=obj,20)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{GaussianGaussian}}, \code{\link{dPosteriorPredictive.GaussianGaussian}}
}
