% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{marginalLikelihood_bySufficientStatistics.GaussianInvWishart}
\alias{marginalLikelihood_bySufficientStatistics.GaussianInvWishart}
\title{Marginal likelihood of a "GaussianInvWishart" object, using sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{GaussianInvWishart}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{ss}{Sufficient statistics of x. In Gaussian and Inverse-Wishart case the sufficient statistic of sample x is a object of type "ssGaussianVar", it can be  generated by the function sufficientStatistics().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of the following model structure:
    \deqn{x \sim Gaussian(mu,Sigma)}
    \deqn{Sigma \sim InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The model structure and prior parameters are stored in a "GaussianInvWishart" object. \cr
Marginal likelihood = p(x|v,S,mu)
}
\seealso{
\code{\link{GaussianInvWishart}}, \code{\link{marginalLikelihood.GaussianInvWishart}}
}
