% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rT}
\alias{rT}
\title{Random Generation for (multivariate) t distribution}
\usage{
rT(n, mu, Sigma = NULL, A = NULL, df = 1)
}
\arguments{
\item{n}{integer, number of samples.}

\item{mu}{numeric, mean vector.}

\item{Sigma}{matrix, Sigma is proportional to the covariance matrix of x, one of Sigma and A should be non-NULL.}

\item{A}{matrix, the Cholesky decomposition of Sigma, an upper triangular matrix, one of Sigma and A should be non-NULL.}

\item{df}{numeric, degrees of freedom.}
}
\value{
A matrix of n rows and length(mu) columns, each row is a sample.
}
\description{
Generate random samples from a (multivariate) t distribution. For a random vector x, the density function is defined as:
    \deqn{Gamma((df + p)/2) / (Gamma(df/2)df^{p/2} pi ^{p/2} |Sigma|^{1/2}) [1+1/df (x-df)^T Sigma^{-1} (x-df)]^{-(df +p)/2}}
Where p is the dimension of x.
}
\examples{
\donttest{
x <- rT(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
plot(x)
}
}
\seealso{
\code{\link{dT}}
}
