% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{marginalLikelihood_bySufficientStatistics.LinearGaussianGaussian}
\alias{marginalLikelihood_bySufficientStatistics.LinearGaussianGaussian}
\title{Marginal likelihood of a "LinearGaussianGaussian" object, using sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{LinearGaussianGaussian}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "LinearGaussianGaussian" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-Gaussian case the sufficient statistic of sample x is a object of type "ssGaussianMean", it can be  generated by the function sufficientStatistics().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of the following model structure:
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
Where Sigma is known. A is a \eqn{dimx x dimz} matrix, x is a \eqn{dimx x 1} random vector, z is a \eqn{dimz x 1} random vector, b is a \eqn{dimm x 1} vector. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "LinearGaussianGaussian" object. \cr
Marginal likelihood = p(x|m,S,Sigma)
}
\seealso{
\code{\link{LinearGaussianGaussian}}, \code{\link{marginalLikelihood.LinearGaussianGaussian}}
}
