% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MAP.GaussianNIG}
\alias{MAP.GaussianNIG}
\title{Maximum A Posteriori (MAP) estimate of a "GaussianNIG" object}
\usage{
\method{MAP}{GaussianNIG}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A named list, the MAP estimate of beta and sigma^2.
}
\description{
Generate the MAP estimate of (beta,sigma^2) in following Gaussian-NIG structure:
   \deqn{x ~ Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 ~ InvGamma(a,b)}
   \deqn{beta ~ Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
The MAP estimates are:
\itemize{
 \item (beta,sigma^2)_MAP = argmax p(beta,sigma^2|m,V,a,b,x,X)
}
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
X <- 1:20
x <- rnorm(20)+ X*0.3
ss <- sufficientStatistics(obj = obj,X=X,x=x)
posterior(obj = obj,ss = ss)
MAP(obj)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}
}
