% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimInstanceSingleCrit.R
\name{OptimInstanceSingleCrit}
\alias{OptimInstanceSingleCrit}
\title{Optimization Instance with budget and archive}
\description{
Wraps a single-criteria \link{Objective} function with extra services for
convenient evaluation. Inherits from \link{OptimInstance}.
\itemize{
\item Automatic storing of results in an \link{Archive} after evaluation.
\item Automatic checking for termination. Evaluations of design points are
performed in batches. Before a batch is evaluated, the \link{Terminator} is
queried for the remaining budget. If the available budget is exhausted, an
exception is raised, and no further evaluations can be performed from this
point on.
}
}
\section{Super class}{
\code{\link[bbotk:OptimInstance]{bbotk::OptimInstance}} -> \code{OptimInstanceSingleCrit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OptimInstanceSingleCrit$new()}}
\item \href{#method-assign_result}{\code{OptimInstanceSingleCrit$assign_result()}}
\item \href{#method-clone}{\code{OptimInstanceSingleCrit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="eval_batch">}\href{../../bbotk/html/OptimInstance.html#method-eval_batch}{\code{bbotk::OptimInstance$eval_batch()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="format">}\href{../../bbotk/html/OptimInstance.html#method-format}{\code{bbotk::OptimInstance$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="objective_function">}\href{../../bbotk/html/OptimInstance.html#method-objective_function}{\code{bbotk::OptimInstance$objective_function()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="print">}\href{../../bbotk/html/OptimInstance.html#method-print}{\code{bbotk::OptimInstance$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceSingleCrit$new(
  objective,
  search_space = NULL,
  terminator,
  keep_evals = "all",
  check_values = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objective}}{(\link{Objective}).}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{\code{terminator}}{(\link{Terminator}).}

\item{\code{keep_evals}}{(\code{character(1)})\cr
Keep \code{all} or only \code{best} evaluations in archive?}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should x-values that are added to the archive be checked for validity?
Search space that is logged into archive.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assign_result"></a>}}
\if{latex}{\out{\hypertarget{method-assign_result}{}}}
\subsection{Method \code{assign_result()}}{
The \link{Optimizer} object writes the best found point
and estimated performance value here. For internal use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceSingleCrit$assign_result(xdt, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}

\item{\code{y}}{(\code{numeric(1)})\cr
Optimal outcome.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceSingleCrit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
