% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjectiveRFun.R
\name{ObjectiveRFun}
\alias{ObjectiveRFun}
\title{Objective interface with custom R function}
\description{
Objective interface where the user can pass a custom R function that expects a list as input.
}
\examples{
library(paradox)
# Define objective function
fun = function(xs) {
  - (xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10
}

# Set domain
domain = ParamSet$new(list(
  ParamDbl$new("x1", -10, 10),
  ParamDbl$new("x2", -5, 5)
))

# Set codomain
codomain = ParamSet$new(list(
  ParamDbl$new("y", tags = "maximize")
))

# Create Objective object
obfun = ObjectiveRFun$new(
  fun = fun,
  domain = domain,
  codomain = codomain,
  properties = "deterministic"
)

}
\section{Super class}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{ObjectiveRFun}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
Objective function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ObjectiveRFun$new()}}
\item \href{#method-eval}{\code{ObjectiveRFun$eval()}}
\item \href{#method-clone}{\code{ObjectiveRFun$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval_dt">}\href{../../bbotk/html/Objective.html#method-eval_dt}{\code{bbotk::Objective$eval_dt()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval_many">}\href{../../bbotk/html/Objective.html#method-eval_many}{\code{bbotk::Objective$eval_many()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format">}\href{../../bbotk/html/Objective.html#method-format}{\code{bbotk::Objective$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print">}\href{../../bbotk/html/Objective.html#method-print}{\code{bbotk::Objective$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFun$new(
  fun,
  domain,
  codomain = NULL,
  id = "function",
  properties = character()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
R function that encodes objective and expects a list with the input for a single point
(e.g. \code{list(x1 = 1, x2 = 2)}) and returns the result either as a numeric vector or a
list (e.g. \code{list(y = 3)}).}

\item{\code{domain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies domain of function.
The \link[paradox:ParamSet]{paradox::ParamSet} should describe all possible input parameters of the objective function.
This includes their \code{id}, their types and the possible range.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{id}}{(\code{character(1)}).}

\item{\code{properties}}{(\code{character()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eval"></a>}}
\if{latex}{\out{\hypertarget{method-eval}{}}}
\subsection{Method \code{eval()}}{
Evaluates input value(s) on the objective function. Calls the R function
supplied by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFun$eval(xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{Input values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFun$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
