% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize a numeric vector}
\usage{
normalize(x, fun = "max", na.rm = TRUE, ...)
}
\arguments{
\item{x}{numeric. A vector.}

\item{fun}{character or function. Should own an \code{na.rm} argument. \code{fun(x)} 
should return either one unique value, or a numeric vector of the same length 
as \code{x}.}

\item{na.rm}{Should missing values be removed in the calculation of \code{fun(x)}?}

\item{...}{Additional arguments to be passed to \code{fun}.}
}
\value{
A numeric vector of the same length as \code{x}.
}
\description{
This function divides \code{x} by the result of \code{fun(x)}.
}
\examples{
x <- rnorm(10)
normalize(x)

}
