% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_var.R
\name{ge_var}
\alias{ge_var}
\alias{ge_var.default}
\title{Genotype by Environment Interaction Variances}
\usage{
\method{ge_var}{default}(.data, .y, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Genotype by Environment Interaction Variances
}
\description{
Calcuates Genotype by Environment Interaction Variances
}
\examples{

data(cultivo2008)
ge_var(
    .data  = cultivo2008
   , .y    = y
   , .gen  = entry
   , .env  = site
   )


}
\references{
Perez-Elizalde, S., Jarquin, D., and Crossa, J. (2011)
 A General Bayesian Estimation Method of Linear–Bilinear Models
 Applied to Plant Breeding Trials With Genotype × Environment Interaction.
 \emph{Journal of Agricultural, Biological, and Environmental Statistics},
  17, 15–37.  (\href{https://link.springer.com/article/10.1007/s13253-011-0063-9}{doi:10.1007/s13253-011-0063-9})
}
\author{
\enumerate{
    \item Muhammad Yaseen (\email{myaseen208@gmail.com})
   }
}
