% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_weather_australia.R
\docType{data}
\name{weather_australia}
\alias{weather_australia}
\title{Weather Data for 3 Australian Cities}
\format{
A data frame with 300 daily observations and 22 variables from 3 Australian weather stations:
\describe{
  \item{location}{one of three weather stations}
  \item{mintemp}{minimum temperature (degrees Celsius)}
  \item{maxtemp}{maximum temperature (degrees Celsius)}
  \item{rainfall}{rainfall (mm)}
  \item{windgustdir}{direction of strongest wind gust}
  \item{windgustspeed}{speed of strongest wind gust (km/h)}
  \item{winddir9am}{direction of wind gust at 9am}
  \item{winddir3pm}{direction of wind gust at 3pm}
  \item{windspeed9am}{wind speed at 9am (km/h)}
  \item{windspeed3pm}{wind speed at 3pm (km/h)}
  \item{humidity9am}{humidity level at 9am (percent)}
  \item{humidity3pm}{humidity level at 3pm (percent)}
  \item{pressure9am}{atmospheric pressure at 9am (hpa)}
  \item{pressure3pm}{atmospheric pressure at 3pm (hpa)}
  \item{temp9am}{temperature at 9am (degrees Celsius)}
  \item{temp3pm}{temperature at 3pm (degrees Celsius)}
  \item{raintoday}{whether or not it rained today (Yes or No)}
  \item{risk_mm}{the amount of rain today (mm)}
  \item{raintomorrow}{whether or not it rained the next day (Yes or No)}
  \item{year}{the year of the date}
  \item{month}{the month of the date}
  \item{day_of_year}{the day of the year}
  }
}
\source{
Data in the original weatherAUS data set were obtained from \url{https://www.bom.gov.au/climate/data/}. Copyright Commonwealth of Australia 2010, Bureau of Meteorology.
}
\usage{
weather_australia
}
\description{
A sub-sample of daily weather information from the weatherAUS data in the rattle package for three Australian cities: Wollongong, Hobart, and Uluru.
}
\keyword{datasets}
