% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{traceplot}
\alias{traceplot}
\title{View trace-plots of output from Bayesian segmentation model}
\usage{
traceplot(data, type)
}
\arguments{
\item{data}{A list of model results that is returned as output from \code{\link{segment_behavior}}.}

\item{type}{character. The type of data that are being plotted from the
Bayesian segmentation model results. Takes either 'nbrks' for the number of
breakpoints or 'LML' for the log marginal likelihood.}
}
\value{
Trace-plots for the number of breakpoints or the log marginal
  likelihood are displayed for each of the animal IDs that were analyzed by
  the segmentation model.
}
\description{
Visualize trace-plots of the number of breakpoints estimated by the model as
well as the log marginal likelihood (LML) for each animal ID.
}
\examples{
\donttest{
#load data
data(tracks.list)

#only retain id and discretized step length (SL) and turning angle (TA) columns
tracks.list2<- purrr::map(tracks.list,
                   subset,
                  select = c(id, SL, TA))


set.seed(1)

# Define model params
alpha<- 1
ngibbs<- 1000
nbins<- c(5,8)

future::plan(future::multisession, workers = 3)  #run all MCMC chains in parallel

dat.res<- segment_behavior(data = tracks.list2, ngibbs = ngibbs, nbins = nbins,
                               alpha = alpha)

future::plan(future::sequential)  #return to single core


#run function
traceplot(data = dat.res, type = "nbrks")
traceplot(data = dat.res, type = "LML")
}

}
