% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_helper_functions.R
\name{summarize_tsegs}
\alias{summarize_tsegs}
\title{Summarize observations within bins per track segment}
\usage{
summarize_tsegs(dat, nbins)
}
\arguments{
\item{dat}{A data frame of \strong{only} the animal ID, track segment number,
and the discretized data for each movement variable. Animal ID and time
segment must be the first two columns of this data frame. This should be a
simplified form of the output from \code{\link{assign_tseg}}.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{dat}.}
}
\value{
A new data frame that contains the animal ID, track segment number,
  and the counts per bin for each movement variable. The names for each of
  these bins are labeled according to the order in which the variables were
  provided to \code{summarize_tsegs}.
}
\description{
Prepares the data that has already been segmented for clustering by Latent
Dirichlet Allocation. This function summarizes the counts observed per
movement variable bin within each track segment per animal ID.
}
\examples{
#load data
data(tracks.seg)

#select only id, tseg, SL, and TA columns
tracks.seg2<- tracks.seg[,c("id","tseg","SL","TA")]

#run function
obs<- summarize_tsegs(dat = tracks.seg2, nbins = c(5,8))


}
