% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-garch_params.R
\name{garch_params}
\alias{garch_params}
\alias{garch_order}
\alias{arch_order}
\alias{mgarch_order}
\alias{garch_t_student}
\alias{asymmetry}
\title{Tuning Parameters for GARCHA Models}
\usage{
garch_order(range = c(0L, 3L), trans = NULL)

arch_order(range = c(0L, 3L), trans = NULL)

mgarch_order(range = c(0L, 3L), trans = NULL)

garch_t_student()

asymmetry()
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A parameter

A parameter

A parameter

A parameter

A parameter
}
\description{
Tuning Parameters for GARCHA Models
}
\details{
The main parameters for GARCHA models are:
\itemize{
\item \code{garch_order}: Integer with the garch order.
\item \code{arch_order}: Integer with the arch_order.
\item \code{mgarch_order}: Integer with the mgarch order.
\item \code{garch_t_student}: A boolean value to specify for a generalized t-student garch model.
\item \code{asymmetry}: a string value for the asymmetric function for an asymmetric GARCH process. By default the
value "none" for standard GARCH process. If "logit" a logistic function is used for asymmetry, and if
"exp" an exponential function is used.
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{markov_chains}: The number of markov chains.
\item \code{adapt_delta}: The thin of the jumps in a HMC method
\item \code{tree_depth}: Maximum depth of the trees
}
}
\examples{
non_seasonal_ar()

non_seasonal_differences()

non_seasonal_ma()


}
