% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.bayesbr.R
\name{residuals.bayesbr}
\alias{residuals.bayesbr}
\title{Residuals for \code{bayesbr} Objects}
\usage{
\method{residuals}{bayesbr}(object, type = c("", "quantile", "sweighted", "pearson","ordinary"),...)
}
\arguments{
\item{object}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{type}{A character containing the residual type returned by the model among the possibilities. The type of residue can be \emph{quantile}, \emph{sweighted}, \emph{pearson} or \emph{ordinary}. The default is \emph{quantile}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector containing the model residual according to the type of residual calculated
}
\description{
A function that receives model information and calculates the residuals according to the required residual.
}
\details{
The definitions of the waste generated by the package are available in Espinheira (2008): "pearson" in Equation 2, "sweighted" in Equation 7; and in Pereira (2019): "quantile" in Equation 5;

The type of residue "response" is calculated from the difference between the estimated theta and the variable response of the model.
}
\examples{
data("CarTask", package = "bayesbr")

bbr = bayesbr(probability~task + NFCCscale,data=CarTask,
             iter = 100, mean_betas = c(1, 0.5,1.2))

residuals(bbr, type = "quantile")
residuals(bbr, type = "ordinary")
residuals(bbr, type = "sweighted")
residuals(bbr, type = "pearson")
}
\references{
\doi{10.1080/0266476042000214501} Ferrari, S., & Cribari-Neto, F. (2004). Beta regression for modelling rates and proportions. \emph{Journal of applied statistics}, \bold{31}(7), 799-815.

\doi{10.1080/00949650701829380} Simas, A. B., & Cordeiro, G. M. (2009). Adjusted Pearson residuals in exponential family nonlinear models. \emph{Journal of Statistical Computation and Simulation}, \bold{79}(4), 411-425.

\doi{10.1080/02664760701834931} Espinheira, P. L., Ferrari, S. L., & Cribari-Neto, F. (2008). On beta regression residuals. \emph{Journal of Applied Statistics}, \bold{35}(4), 407-419.

\doi{10.1080/00949655.2012.736993} Anholeto, T., Sandoval, M. C., & Botter, D. A. (2014). Adjusted Pearson residuals in beta regression models. \emph{Journal of Statistical Computation and Simulation}, \bold{84}(5), 999-1014.

\doi{10.1080/03610918.2017.1381740} Pereira, G. H. (2019). On quantile residuals in beta regression. \emph{Communications in Statistics-Simulation and Computation}, \bold{48}(1), 302-316.
}
\seealso{
\code{\link{bayesbr}},\code{\link{summary.bayesbr}},\code{\link{predict.bayesbr}}
}
