% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{mig.map}
\alias{mig.map}
\alias{mig.ggmap}
\alias{mig.map.gvis}
\alias{mig.map.all}
\alias{get.mig.map.parameters}
\title{World Map of Net Migration Rate}
\usage{
mig.map(pred, ...)

mig.ggmap(pred, ...)

mig.map.gvis(pred, ...)

mig.map.all(
  pred,
  output.dir,
  output.type = "png",
  mig.range = NULL,
  nr.cats = 50,
  same.scale = TRUE,
  quantile = 0.5,
  file.prefix = "migwrldmap_",
  ...
)

get.mig.map.parameters(
  pred,
  mig.range = NULL,
  nr.cats = 50,
  same.scale = TRUE,
  quantile = 0.5,
  palette = "Blue-Red",
  ...
)
}
\arguments{
\item{pred}{Object of class \code{\link{bayesMig.prediction}}. Note that location codes
must correspond to the UN country codes in order to generate a world map.}

\item{\dots}{In \code{mig.map}, \dots are all arguments that can be passed 
to \code{\link[bayesTFR]{tfr.map}}, such as \code{quantile}, \code{year}, 
\code{projection.index}, \code{par.name}, \code{adjusted}, \code{device}, \code{main}, 
\code{device.args}, and \code{data.args}. 
In \code{mig.map.gvis}, \dots are all arguments that can be passed 
to \code{\link[bayesTFR]{tfr.map.gvis}}. In \code{e0.ggmap}, \dots are arguments that can be passed 
to \code{\link[bayesTFR]{tfr.ggmap}}. In addition, functions that use the \pkg{rworldmap} package accept 
arguments passed to the \code{\link[rworldmap]{mapCountryData}} function of the \pkg{rworldmap} package.}

\item{output.dir}{Directory into which resulting maps are stored.}

\item{output.type}{Type of the resulting files. It can be \dQuote{png}, \dQuote{pdf}, 
\dQuote{jpeg}, \dQuote{bmp}, \dQuote{tiff}, or \dQuote{postscript}.}

\item{mig.range}{Range of the migration rate to be displayed. It is of the form 
\code{c(}\var{mig.min}, \var{mig.max}\code{)}. By default, the whole available range is considered. 
Note that countries with values outside of the given range will appear white.}

\item{nr.cats}{Number of color categories.}

\item{same.scale}{Logical controlling if maps for all years of this prediction object 
should be on the same color scale.}

\item{quantile}{Quantile for which the map should be generated. It must be equal to one of the 
values in \code{dimnames(pred$quantiles)[[2]]}, 
i.e. 0, 0.025, 0.05, 0.1, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6, 0.7, 0.75, 0.8, 0.9, 0.95, 0.975, 1. 
Value 0.5 corresponds to the median.}

\item{file.prefix}{Prefix for file names.}

\item{palette}{Color palette to use.}
}
\value{
\code{get.mig.map.parameters} returns a list with elements:
\describe{
\item{pred}{The \code{\link{bayesMig.prediction}} object used in the function.}
\item{quantile}{Value of the argument \code{quantile}.}
\item{catMethod}{If the argument \code{same.scale} is \code{TRUE}, this element 
     contains breakpoints for categorization generated using the quantiles.
     Otherwise, it is \code{NULL}.}
\item{numCats}{Number of categories.}
\item{coulourPalette}{The color palette.}
}
}
\description{
Generates a world map of the net migration rate for given quantile and 
    time period, which can be either projection or estimation time period, using different techniques: 
    \code{mig.map} and \code{mig.map.all} use \pkg{rworldmap}, \code{mig.ggmap} uses \pkg{ggplot2}, and 
    \code{mig.map.gvis} creates an interactive map via \pkg{GoogleVis}. A map of 
    country-specific model parameters is also supported.
}
\details{
The functions only work for national simulations where location codes 
    correspond to the countries' UN codes.  
    
    \code{mig.map} creates a single map for the given time period and quantile. 
    \code{mig.map.all} generates a sequence of maps, namely one for each projection period. 
    If the package \pkg{fields} is installed, a color bar legend at the botom of the map is created.
    
    Function \code{get.mig.map.parameters} can be used in combination with \code{mig.map}. 
    (Note that \code{get.mig.map.parameters} is called from inside of \code{mig.map.all}.) 
    It sets breakpoints for the color scheme.
    
    Function \code{mig.ggmap} is similar to \code{mig.map}, but used the \pkg{ggplot2} package 
    in combination with the \code{geom_sf} function.
    
    Function \code{mig.map.gvis} creates an interactive map using the \pkg{googleVis} package 
    and opens it in an internet browser. It also generates a table of the mapped values that 
    can be sorted by columns interactively in the browser. 
    
    By default, \code{mig.map}, \code{mig.ggmap} and \code{mig.map.gvis} produce maps of net migration rates. 
    Alternatively, the functions can be used to plot country-specific MCMC parameters into a world map. 
    They are given by the argument \code{par.name}. One can pass any value from 
    \code{\link{mig.parameter.names.cs}()}.
}
\seealso{
\code{\link[bayesTFR]{tfr.map}}
}
