% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeLopodData.R
\name{shapeLopodData}
\alias{shapeLopodData}
\title{Create a LopodData object from Raster data}
\usage{
shapeLopodData(Shapefile, fieldN = "sampEffort", fieldY = "detections",
  Adjacency = T, keepFields = T)
}
\arguments{
\item{Shapefile}{SpatialPolygonsDataFrame Object with at least two Fields corresponding to sampling effort and number of detections in each feature}

\item{fieldN}{Field in Shapefile corresponding to sampling effort (number of sampling events)in each feature.}

\item{fieldY}{Field in Shapefile corresponding to number of detections in each feature.}

\item{Adjacency}{Boolean. If TRUE, and adjacency matrix is computed.}

\item{keepFields}{Boolean. If TRUE, other fields of the Shapefile will be kept and "sampEffort" and "detections" will be added. If FALSE, only the "sampEffort" and "detections" will be kept in the LopodData Object.}
}
\value{
A LopodData object to be used in modelLopod.
}
\description{
Create a LopodData object from Raster data
}
\examples{
data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = FALSE, keepFields = FALSE)

\dontrun{
data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = TRUE, keepFields = TRUE)
}
}
