% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{ppc_plots}
\alias{ppc_plots}
\alias{ppc_dens}
\alias{ppc_dens,bayesGAMfit-method}
\alias{ppc_dens,posteriorPredictObject-method}
\alias{ppc_dens_overlay}
\alias{ppc_dens_overlay,bayesGAMfit-method}
\alias{ppc_dens_overlay,posteriorPredictObject-method}
\alias{ppc_hist}
\alias{ppc_hist,bayesGAMfit-method}
\alias{ppc_hist,posteriorPredictObject-method}
\alias{ppc_boxplot}
\alias{ppc_boxplot,bayesGAMfit-method}
\alias{ppc_boxplot,posteriorPredictObject-method}
\alias{ppc_freqpoly}
\alias{ppc_freqpoly,bayesGAMfit-method}
\alias{ppc_freqpoly,posteriorPredictObject-method}
\alias{ppc_ecdf_overlay}
\alias{ppc_ecdf_overlay,bayesGAMfit-method}
\alias{ppc_ecdf_overlay,posteriorPredictObject-method}
\title{Plotting for MCMC visualization and diagnostics provided by \code{bayesplot} package}
\usage{
ppc_dens(object, ...)

\S4method{ppc_dens}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_dens}{posteriorPredictObject}(object, ...)

ppc_dens_overlay(object, ...)

\S4method{ppc_dens_overlay}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_dens_overlay}{posteriorPredictObject}(object, ...)

ppc_hist(object, ...)

\S4method{ppc_hist}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_hist}{posteriorPredictObject}(object, ...)

ppc_boxplot(object, ...)

\S4method{ppc_boxplot}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_boxplot}{posteriorPredictObject}(object, ...)

ppc_freqpoly(object, ...)

\S4method{ppc_freqpoly}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_freqpoly}{posteriorPredictObject}(object, ...)

ppc_ecdf_overlay(object, ...)

\S4method{ppc_ecdf_overlay}{bayesGAMfit}(object, draws = NULL, ...)

\S4method{ppc_ecdf_overlay}{posteriorPredictObject}(object, ...)
}
\arguments{
\item{object}{an object of class \code{bayesGAMfit}}

\item{...}{optional additional arguments to pass to the \code{bayesplot} functions}

\item{draws}{An integer indicating the number of draws to return. The default and maximum number of draws is the size of the posterior sample.}
}
\value{
These functions call various plotting functions from the \code{bayesplot} package, which returns a list including \code{ggplot2} objects.
}
\description{
Plots of Rhat statistics, ratios of effective sample size to total sample
size, and autocorrelation of MCMC draws.
}
\section{Plot Descriptions from the \code{bayesplot} package documentation}{

\itemize{
\item{\code{ppc_hist(object, draws=NULL, ...)}}{
A separate histogram estimate is displayed for y and each dataset (row) in yrep. For these plots yrep should therefore contain only a small number of rows.
}
\item{\code{ppc_boxplot(object, draws=NULL, ...)}}{
A separate box and whiskers plot is displayed for y and each dataset (row) in yrep. For these plots yrep should therefore contain only a small number of rows.
}
\item{\code{ppc_freqpoly(object, draws=NULL, ...)}}{
A separate shaded frequency polygon is displayed for y and each dataset (row) in yrep. For these plots yrep should therefore contain only a small number of rows.
}
\item{\code{ppc_dens(object, draws=NULL, ...)}}{
A separate smoothed kernel density estimate is displayed for y and each dataset (row) in yrep. For these plots yrep should therefore contain only a small number of rows.
}
\item{\code{ppc_dens_overlay(object, draws=NULL, ...)}}{
Kernel density estimates of each dataset (row) in \code{yrep} are overlaid, with the distribution of \code{y} itself on top (and in a darker shade).
}
\item{\code{ppc_ecdf_overlay(object, draws=NULL, ...)}}{
Empirical CDF estimates of each dataset (row) in \code{yrep} are overlaid, with the distribution of \code{y} itself on top (and in a darker shade).
}
}
}

\examples{
f <- bayesGAM(weight ~ np(height), data = women, 
              family = gaussian, iter=500, chains = 1)
ppc_dens(f, draws=2)
}
\references{
Gabry, Jonah and Mahr, Tristan (2019).  \emph{bayesplot:  Plotting for Bayesian Models}.  \url{https://mc-stan.org/bayesplot/}

Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman, A (2019).  \emph{Visualization in Bayesian Workflow}.  Journal of the Royal Statistical Society: Series A. Vol 182.  Issue 2.  p.389-402.

Gelman, A. and Rubin, D. (1992) \emph{Inference from Iterative Simulation Using Multiple Sequences}.  Statistical Science 7(4) 457-472.

Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and Gelman, A. (2019), Visualization in Bayesian workflow. J. R. Stat. Soc. A, 182: 389-402. doi:10.1111/rssa.12378.
}
