% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchMap.R
\name{batchMap}
\alias{batchMap}
\title{Map Operation for Batch Systems}
\usage{
batchMap(fun, ..., args = list(), more.args = list(),
  reg = getDefaultRegistry())
}
\arguments{
\item{fun}{[\code{function}]\cr
Function to map over arguments provided via \code{...}.
Parameters given via \code{args} or \code{...} are passed as-is, in the respective order and possibly named.
If the function has the named formal argument \dQuote{.job}, the \code{\link{Job}} is passed to the function
on the slave.}

\item{...}{[ANY]\cr
Arguments to vectorize over (list or vector).
Shorter vectors will be recycled (possibly with a warning any length is not a multiple of the longest length).
Mutually exclusive with \code{args}.
Note that although it is possible to iterate over large objects (e.g., lists of data frames or matrices), this usually
hurts the overall performance and thus is discouraged.}

\item{args}{[\code{list} | \code{data.frame}]\cr
Arguments to vectorize over as (named) list or data frame.
Shorter vectors will be recycled (possibly with a warning any length is not a multiple of the longest length).
Mutually exclusive with \code{...}.}

\item{more.args}{[\code{list}]\cr
A list of further arguments passed to \code{fun}.
Default is an empty list.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link{data.table}}] with ids of added jobs stored in column \dQuote{job.id}.
}
\description{
A parallel and asynchronous \code{\link[base]{Map}}/\code{\link[base]{mapply}} for batch systems.
Note that this function only defines the computational jobs.
The actual computation is started with \code{\link{submitJobs}}.
Results and partial results can be collected with \code{\link{reduceResultsList}}, \code{\link{reduceResults}} or
\code{\link{loadResult}}.

For a synchronous \code{\link[base]{Map}}-like execution, see \code{\link{btmapply}}.
}
\examples{
# example using "..." and more.args
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
f = function(x, y) x^2 + y
ids = batchMap(f, x = 1:10, more.args = list(y = 100), reg = tmp)
getJobPars(reg = tmp)
testJob(6, reg = tmp) # 100 + 6^2 = 136

# vector recycling
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
f = function(...) list(...)
ids = batchMap(f, x = 1:3, y = 1:6, reg = tmp)
getJobPars(reg = tmp)

# example for an expand.grid()-like operation on parameters
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
ids = batchMap(paste, args = CJ(x = letters[1:3], y = 1:3), reg = tmp)
getJobPars(reg = tmp)
testJob(6, reg = tmp)
}
\seealso{
\code{\link{batchReduce}}
}
