% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkIds.R
\name{chunkIds}
\alias{chunkIds}
\title{Chunk Jobs for Sequential Execution}
\usage{
chunkIds(ids = NULL, n.chunks = NULL, chunk.size = NULL,
  group.by = character(0L), reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.}

\item{n.chunks}{[\code{integer(1)}]\cr
Requested number of chunks.
The function \code{chunk} distributes the number of elements in \code{x} evenly while
\code{lpt} tries to even out the sum of elements in each chunk.
If more chunks than necessary are requested, empty chunks are ignored.
Mutually exclusive with \code{chunks.size}.}

\item{chunk.size}{[\code{integer(1)}]\cr
Requested chunk size for each single chunk.
For \code{chunk} this is the number of elements in \code{x}, for \code{binpack} the size
is determined by the sum of values in \code{x}.
Mutually exclusive with \code{n.chunks}.}

\item{group.by}{[\code{character(0)}]\cr
If \code{ids} is a \code{\link{data.frame}} with additional columns
(in addition to the required column \dQuote{job.id}), then the chunking is performed using
subgroups defined by the columns set in \code{group.by}.
See example.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link[data.table]{data.table}}] with columns \dQuote{job.id} and \dQuote{chunk}.
}
\description{
This function is deprecated in favor of the more flexible \code{chunk}, \code{lpt} and \code{binpack}.
}
\seealso{
\code{\link{chunk}} \code{\link{binpack}} \code{\link{lpt}}
}
