% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btlapply.R
\name{btlapply}
\alias{btlapply}
\alias{btmapply}
\title{Synchronous Apply Functions}
\usage{
btlapply(X, fun, ..., resources = list(), n.chunks = NULL,
  chunk.size = NULL, reg = makeRegistry(file.dir = NA))

btmapply(fun, ..., more.args = list(), simplify = FALSE,
  use.names = TRUE, resources = list(), n.chunks = NULL,
  chunk.size = NULL, reg = makeRegistry(file.dir = NA))
}
\arguments{
\item{X}{[\code{\link[base]{vector}}]\cr
Vector to apply over.}

\item{fun}{[\code{function}]\cr
Function to apply.}

\item{...}{[\code{ANY}]\cr
Additional arguments passed to \code{fun} (\code{btlapply}) or vectors to map over (\code{btmapply}).}

\item{resources}{[\code{named list}]\cr
Computational  resources for the jobs to submit. The actual elements of this list
(e.g. something like \dQuote{walltime} or \dQuote{nodes}) depend on your template file, exceptions are outlined in the section 'Resources'.
Default settings for a system can be set in the configuration file by defining the named list \code{default.resources}.
Note that these settings are merged by name, e.g. merging \code{list(walltime = 300)} into \code{list(walltime = 400, memory = 512)}
will result in \code{list(walltime = 300, memory = 512)}.
Same holds for individual job resources passed as additional column of \code{ids} (c.f. section 'Resources').}

\item{n.chunks}{[\code{integer(1)}]\cr
Passed to \code{\link{chunk}} before \code{\link{submitJobs}}.}

\item{chunk.size}{[\code{integer(1)}]\cr
Passed to \code{\link{chunk}} before \code{\link{submitJobs}}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}

\item{more.args}{[\code{list}]\cr
Additional arguments passed to \code{fun}.}

\item{simplify}{[\code{logical(1)}]\cr
Simplify the results using \code{\link[base]{simplify2array}}?}

\item{use.names}{[\code{logical(1)}]\cr
Use names of the input to name the output?}
}
\value{
[\code{list}] List with the results of the function call.
}
\description{
This is a set of functions acting as counterparts to the sequential popular apply functions in base R:
\code{btlapply} for \code{\link[base]{lapply}} and \code{btmapply} for \code{\link[base]{mapply}}.

Internally, jobs are created using \code{\link{batchMap}} on the provided registry.
If no registry is provided, a temporary registry (see argument \code{file.dir} of \code{\link{makeRegistry}}) and \code{\link{batchMap}}
will be used.
After all jobs are terminated (see \code{\link{waitForJobs}}), the results are collected and returned as a list.

Note that these functions are one suitable for short and fail-safe operations
on batch system. If some jobs fail, you have to retrieve partial results from the
registry directory yourself.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
btlapply(1:3, function(x) x^2)
btmapply(function(x, y, z) x + y + z, x = 1:3, y = 1:3, more.args = list(z = 1), simplify = TRUE)
}
