% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VI.lb.R
\name{VI.lb}
\alias{VI.lb}
\title{Minimum VI lower bound}
\usage{
VI.lb(cls, psm)
}
\arguments{
\item{cls}{A clustering for which the lower bound of the Variation of
Information is calculated.}

\item{psm}{The posterior similarity matrix which `cls` is a summary thereof.}
}
\value{
A vector of the the lower bound of the Variation of Information
for
}
\description{
Local implementation of S. Wade's `minVI` function from their
`mcclust.ext` package (available from github).
Reimplemented here to avoid dependency on a non-CRAN package. Computes the
lower bound to the posterior expected Variation of Information. For full
details please see the aforementioned package and Wade and Ghahramani, 2018,
'Bayesian Cluster Analysis: Point Estimation and Credible Balls (with
Discussion)'.
}
\examples{
\dontrun{
# MCMC samples and BIC vector
mcmc_outputs <- runMCMCChains(
  X,
  n_chains,
  R,
  thin,
  batch_vec,
  type
)

# Note that in this toy example we have not applied a burn in
psm <- createSimilarityMat(mcmc_outputs[[1]]$samples)
VI.lb(mcmc_outputs[[1]]$samples[1, ], psm)
}
}
